import csv
import matplotlib.pyplot as plt
with open('pvdata.csv', newline='') as csvfile:
    dataArray=[];
    spamreader = csv.reader(csvfile)
    i=0;
    for row in spamreader:
        if(i>3):
            dataArray.append(float(row[2].replace(",",".")))
        i+=1
    #print(dataArray)
    
    print("Max value of solar radiation is: "+str(max(dataArray)))
    print("Avg value of solar radiation is: "+str(sum(dataArray)/len(dataArray)))
    startIndex=0
    for i in range(0,len(dataArray)):
        if dataArray[i]>0:
            startIndex=i
            break
    #print(i)
    hours=int(startIndex*5/60)
    minutes=(startIndex*5)-hours*60
    print("Starting time of solar radiation is: "+str(hours)+":"+str(minutes))
    lastIndex=0
    for i in range(len(dataArray)-1,0,-1):
        if dataArray[i]>0:
            lastIndex=i
            break
    hours=int(lastIndex*5/60)
    minutes=(lastIndex*5)-hours*60
    print("Ending time of solar radiation is: "+str(hours)+":"+str(minutes))
    timeDiff=lastIndex-startIndex
    hours=int(timeDiff*5/60)
    minutes=(timeDiff*5)-hours*60
    lightDayPercentage=timeDiff*5/(60*24)
    print("Duration of solar irradiation is: "+str(hours)+":"+str(minutes)+" ("+str(lightDayPercentage)+" of the 24h)")
    print("Avg value of solar radiation during the light day is: "+str(sum(dataArray[startIndex:lastIndex])/len(dataArray[startIndex:lastIndex])))
    plt.plot(dataArray)
    plt.title("Solar Irradiation")
    plt.xlabel("Index")
    plt.ylabel("Value")
    plt.show()
