<?php
require_once('BaseList.php');
require_once('Category.php');
class CategoryList extends BaseList{
    public function add($params){
        $this->lastId++;
        $element=new Category($this->lastId, $params['name']);
        array_push($this->list,$element);
    }
    public function update($params){
        for ($i=0; $i<count($this->list);$i++){
            if($params['id']==$this->list[$i]->getId()){
                $this->list[$i]->update($params['name']);
                break;
            }
        }
    }
    public function readFromCSVFile($filePath){
        $file = fopen($filePath, 'r');
        while (($row = fgetcsv($file,10000,$delimiter=',', $enclosure="`",$escapestring="\\")) !== FALSE) {
            $this->add(['name'=>$row[0]]);
        }
        fclose($file);
    }
    public function displayAsJSON(){
        $content='{
  "categories":[';
        for ($i=0; $i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsJSON();
            $content.=",";
        }
        $content.="]
        }";
        echo $content;
    }
    public function displayAsXML(){
        $content='<categories>';
        for ($i=0; $i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsXML();
        }
        $content.="</categories>";
        echo $content;
    }
    
}