<?php
require_once('BaseEntity.php');
class Backpack extends BaseEntity{
    private $model;
    private $vendor;
    private $price;
    private $category;
    private $properties;
    public function __construct($id, $model,$vendor,$price,$category,$properties){
        $this->id=$id;
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->category=$category;
        $this->properties=$properties;
    }
    public function display(){
        echo $this->id.". ".$this->vendor." ".$this->model."</br>";
        echo "Категорія: <i>".$this->category."</i></br>";
        echo "Ціна: <b>".$this->price."</b> грн</br>";
        echo "<b>Характеристики:</b></br>";
        foreach (json_decode($this->properties) as $propertyName => $propertyValue) {
            echo $propertyName . ": " . $propertyValue . "</br>";
        }
    }
    public function update($model,$vendor,$price,$category,$properties){
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->category=$category;
        $this->properties=$properties;
    }
    public function __destruct(){
        $this->id=null;
        $this->model=null;
        $this->vendor=null;
        $this->price=null;
        $this->category=null;
        $this->properties=null;
    }
    public function getAsAssocArray(){
        return get_object_vars($this);
    }
    public function getAsIndexedArray(){
        return [$this->getAsAssocArray()['model'],
        $this->getAsAssocArray()['vendor'],
        $this->getAsAssocArray()['price'],
        $this->getAsAssocArray()['category'],
        $this->getAsAssocArray()['properties']];
    }
    public function getAsJSON(){
        return '{
            "id":"'.$this->id.'",
            "model":"'.$this->model.'",
            "vendor":"'.$this->vendor.'",
            "price":"'.$this->price.'",
            "category":"'.$this->category.'",
            "properties":"'.$this->properties.'"
            }';
    }
    public function getAsXML(){
        return '<backpack>
                    <id>'.$this->id.'</id>
                    <model>'.$this->model.'</model>
                    <vendor>'.$this->vendor.'</vendor>
                    <price>'.$this->price.'</price>
                    <category>'.$this->category.'</category>
                    <properties>'.$this->properties.'</properties>
                </backpack>';
    }
}