<?php
require_once('BaseList.php');
require_once('Backpack.php');
class BackpackList extends BaseList{
    public function add($params){
        $this->lastId++;
        $element=new Backpack($this->lastId, $params['model'],$params['vendor'],$params['price'], $params['category'],$params['properties']);
        array_push($this->list,$element);
    }
    public function update($params){
        for ($i=0; $i<count($this->list);$i++){
            if($params['id']==$this->list[$i]->getId()){
                $this->list[$i]->update($params['model'],$params['vendor'],$params['price'], $params['category'],$params['properties']);
                break;
            }
        }
    }
    public function readFromCSVFile($filePath){
        $file = fopen($filePath, 'r');
        while (($row = fgetcsv($file,10000,$delimiter=',', $enclosure="`",$escapestring="\\")) !== FALSE) {
            $this->add(['model'=>$row[0],
            'vendor'=>$row[1],
            'price'=>$row[2],
            'category'=>$row[3],
            'properties'=>$row[4]
                        ]);
        }
        fclose($file);
    }
    public function displayAsJSON(){
        $content='{
  "backpacks":[';
        for ($i=0; $i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsJSON();
            $content.=",";
        }
        $content.="]
        }";
        echo $content;
    }
    public function displayAsXML(){
        $content='<backpacks>';
        for ($i=0; $i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsXML();
        }
        $content.="</backpacks>";
        echo $content;
    }
}