<?php
abstract class BaseList{
    protected $list;
    protected $lastId;
    public function __construct(){
        $this->list=[];
        $this->lastId=0;
    }
    public function writeToCSVFile($filePath){
        $file = fopen($filePath, 'w');
        foreach($this->list as $element){
            //var_dump($element->getAsAssocArray());
            fputcsv($file, $element->getAsIndexedArray(),$delimiter=',', $enclosure="`",$escapestring="\\");   
        }
        fclose($file);
    }
    public abstract function add($params);
    public abstract function readFromCSVFile($filePath);
    public function display(){
        for ($i=0; $i<count($this->list);$i++){
            $this->list[$i]->display();
        }
    }
    public abstract function update($params);
    public function delete($id){
        for ($i=0; $i<count($this->list);$i++){
            if($id==$this->list[$i]->getId()){
                array_splice($this->list, $i, 1);
                break;
            }
        }
    }
}