<?php
require_once('BaseEntity.php');
class Category extends BaseEntity{
    private $name;
    public function __construct($id, $name){
        $this->id=$id;
        $this->name=$name;
    }
    public function display(){
        echo $this->id.". ".$this->name."</br>";
    }
    public function update($name){
        $this->name=$name;
    }
    public function getAsAssocArray(){
        return get_object_vars($this);
    }
    public function getAsIndexedArray(){
        return [$this->getAsAssocArray()['name']];
    }
    public function getAsJSON(){
        return '{
            "id":"'.$this->id.'",
            "name":"'.$this->name.'"
            }';
    }
    public function getAsXML(){
        return '<category>
                    <id>'.$this->id.'</id>
                    <name>'.$this->name.'</name>
                </category>';
    }
    public function __destruct(){
        $this->id=null;
        $this->name=null;
    }
}
