<?php
require_once('BaseList.php');
require_once('Property.php');
class PropertyList extends BaseList{
    public function add($params){
        $this->lastId++;
        $element=new Property($this->lastId, $params['name'],$params['units']);
        array_push($this->list,$element);
    }
    public function update($params){
        for ($i=0; $i<count($this->list);$i++){
            if($params['id']==$this->list[$i]->getId()){
                $this->list[$i]->update($params['name'],$params['units']);
                break;
            }
        }
    }
    public function readFromCSVFile($filePath){
        $file = fopen($filePath, 'r');
        while (($row = fgetcsv($file,10000,$delimiter=',', $enclosure="`",$escapestring="\\")) !== FALSE) {
            $this->add(['name'=>$row[0],'units'=>$row[1]]);
        }
        fclose($file);
    }
    public function displayAsJSON(){
        $content='{
  "properties":[';
        for ($i=0; $i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsJSON();
            $content.=",";
        }
        $content.="]
        }";
        echo $content;
    }
    public function displayAsXML(){
        $content='<properties>';
        for ($i=0; $i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsXML();
        }
        $content.="</properties>";
        echo $content;
    }
}