<?php
require_once('BaseEntity.php');
class Backpack extends BaseEntity{
    private $model;
    private $vendor;
    private $price;
    private $category;
    private $properties;
    public function __construct($id, $model,$vendor,$price,$category,$properties){
        $this->id=$id;
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->category=$category;
        $this->properties=$properties;
    }
    public function display(){
        echo $this->id.". ".$this->vendor." ".$this->model."</br>";
        echo "Категорія: <i>".$this->category."</i></br>";
        echo "Ціна: <b>".$this->price."</b> грн</br>";
        echo "<b>Характеристики:</b></br>";
        foreach (json_decode($this->properties) as $propertyName => $propertyValue) {
            echo $propertyName . ": " . $propertyValue . "</br>";
        }
    }
    public function update($model,$vendor,$price,$category,$properties){
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->category=$category;
        $this->properties=$properties;
    }
    public function __destruct(){
        $this->id=null;
        $this->model=null;
        $this->vendor=null;
        $this->price=null;
        $this->category=null;
        $this->properties=null;
    }
    public function getAsIndexedArray(){
        return [$this->model,$this->vendor,$this->price,$this->category,$this->properties];
    }
}