<?php
require_once('BaseEntity.php');
class Property extends BaseEntity{
    private $name;
    private $units;
    public function __construct($id, $name, $units){
        $this->id=$id;
        $this->name=$name;
        $this->units=$units;
    }
    public function display(){
        echo $this->id.". ".$this->name." <i>(".$this->units.")</i></br>";
    }
    public function update($name, $units){
        $this->name=$name;
        $this->units=$units;
    }
    public function getAsJSON(){
        return '{
            "id": "'.$this->id.'",
            "name": "'.$this->name.'",
            "units": "'.$this->units.'"
        }';
    }
    public function getAsXML(){
        return '<property>
                    <id>'.$this->id.'</id>
                    <name>'.$this->name.'</name>
                    <units>'.$this->name.'</units>
                </property>';
    }
    public function __destruct(){
        $this->id=null;
        $this->name=null;
        $this->units=null;
    }
    public function getAsIndexedArray(){
        return [$this->name,$this->units];
    }
}