<?php
require_once('BaseList.php');
require_once('Backpack.php');
class BackpackList extends BaseList{
    public function add($params){
        $this->lastId++;
        $elem=new Backpack($this->lastId,$params['model'],$params['vendor'],$params['price'],$params['category'],$params['properties']);
        array_push($this->list, $elem);
    }
    public function update($params){
        for ($i=0;$i<count($this->list);$i++){
            if($this->list[$i]->getId()==$params['id']){
                $this->list[$i]->update($params['model'],$params['vendor'],$params['price'],$params['category'],$params['properties']);
                break;
            }
        }
    }
    public function getAsJSON(){
        $content='{
    "backpacks": [';
        for ($i=0;$i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsJSON().",";
        }
        $content = substr($content, 0, -1);
        $content.='    ]
        }';
        return $content;
    }
    public function getAsXML(){
        $content='<backpacks>
        ';
        for ($i=0;$i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsXML();
        }
        $content.='</backpacks>';
        return $content;
    }
    public function readFromCSV($filePath){
        $fp = fopen($filePath, 'r');
        if ($fp === false) {
            die('Error: Cannot open the CSV file.');
        }
        while (($row = fgetcsv($fp,10000,",","`","\\")) !== false) {
            $this->add(['model'=>$row[0], 'vendor'=>$row[1],'price'=>$row[2],'category'=>$row[3],'properties'=>$row[4]]);
        }
        fclose($fp);
    }
    
}