<?php
require_once('BaseEntity.php');
class Backpack extends BaseEntity{
    private $model;
    private $vendor;
    private $price;
    private $category;
    private $properties;
    public function __construct($id, $model,$vendor,$price,$category,$properties){
        $this->id=$id;
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->category=$category;
        $this->properties=$properties;
    }
    public function display(){
        echo $this->id.". ".$this->vendor." ".$this->model."</br>";
        echo "Категорія: <i>".$this->category."</i></br>";
        echo "Ціна: <b>".$this->price."</b> грн</br>";
        echo "<b>Характеристики:</b></br>";
        foreach (json_decode($this->properties) as $propertyName => $propertyValue) {
            echo $propertyName . ": " . $propertyValue . "</br>";
        }
    }
    public function update($model,$vendor,$price,$category,$properties){
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->category=$category;
        $this->properties=$properties;
    }
    public function __destruct(){
        $this->id=null;
        $this->model=null;
        $this->vendor=null;
        $this->price=null;
        $this->category=null;
        $this->properties=null;
    }
    public function getAsJSON(){
        return '{
            "id": "'.$this->id.'",
            "model": "'.$this->model.'",
            "vendor": "'.$this->vendor.'",
            "price": "'.$this->price.'",
            "category": "'.$this->category.'",
            "properties": '.$this->properties.'
        }';
    }
    public function getAsXML(){
        $properties='';
        foreach (json_decode($this->properties) as $propertyName => $propertyValue) {
            $properties.='<property>
                            <name>'.$propertyName.'</name>
                            <value>'.$propertyValue.'</value>
            </property>';
        }
        return '<backpack>
                    <id>'.$this->id.'</id>
                    <model>'.$this->model.'</model>
                    <vendor>'.$this->vendor.'</vendor>
                    <price>'.$this->price.'</price>
                    <category>'.$this->category.'</category>
                    <properties>'.$properties.'</properties>
                </backpack>';
    }
    public function getAsAssociativeArray(){
        return [
                'id'=>$this->id,
                'model'=>$this->model,
                'vendor'=>$this->vendor,
                'price'=>$this->price,
                'category'=>$this->category,
                'properties'=>$this->properties
                ];
    }
    public function getAsTableRow(){
        $properties="";
        foreach (json_decode($this->properties) as $propertyName => $propertyValue) {
            $properties.= $propertyName . ": " . $propertyValue . "</br>";
        }
        return '<tr>
                    <td>'.$this->id.'</td>
                    <td>'.$this->model.'</td>
                    <td>'.$this->vendor.'</td>
                    <td>'.$this->category.'</td>
                    <td>'.$this->price.'</td>
                    <td>'.$properties.'</td>
                    <td>
                        <a class="btn btn-warning" href="./backpacks.php?action=update&id='.$this->id.'">Редагувати</a>
                        <a class="btn btn-danger" href="./backpacks.php?action=delete&id='.$this->id.'">Видалити</a>
                    </td>
                </tr>';
    }
    public function getAsIndexedArray(){
        return [$this->model,$this->vendor,$this->price,$this->category,$this->properties];
    }
}