<?php
require_once('./app/dbConnect.php');
require_once('./app/Category.php');
require_once('./app/BaseList.php');
class CategoryList extends BaseList{
    public function add($params){
        $newObj=new Category($params);
        array_push($this->list, $newObj);
    }
    public function loadFromDataBase(){
        global $conn;
        $sql = "SELECT * FROM categories";
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $this->add($row);
            }
        } else {
        echo "0 results";
        }
    }
    public function getFromDatabaseByID($id){
        global $conn;
        $sql = "SELECT * FROM categories WHERE id=".$id;
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                return $row;
            }
        } else {
        echo "0 results";
        }
    }
    public function insertIntoDataBase($params){
        global $conn;
        $stmt = $conn->prepare("INSERT INTO categories VALUES (DEFAULT, ?)");
        $stmt->bind_param("s", $params['name']);
        $stmt->execute();
    }
    public function updateInDataBaseById($params){
        global $conn;
        $stmt = $conn->prepare("UPDATE categories SET name=? WHERE id=?");
        $stmt->bind_param("ss", $params['name'], $params['id']);
        $stmt->execute();
    }
    public function deleteFromDataBaseById($id){
        global $conn;
        $stmt = $conn->prepare("DELETE FROM categories WHERE id=?");
        $stmt->bind_param("s",$id);
        $stmt->execute();
    }
    public function displayAsOptions($id){
        $content='';
        for ($i=0;$i<count($this->list);$i++){
            if($id==$this->list[$i]->getId()){
                $content.=$this->list[$i]->displayAsActiveOption();
            } else{
                $content.=$this->list[$i]->displayAsOption();
            }
            
        }
        return $content;
    }
    public function destruct($params){
        global $conn;
        $conn->close();
    }
}