<?php
require_once('./app/BaseEntity.php');
    class Property extends BaseEntity{
        private $name;
        private $units;
        public function __construct($params){
            $this->id=$params['id'];
            $this->name=$params['name'];
            $this->units=$params['units'];
        }
        public function display(){
            echo "$this->id. $this->name ($this->units)</br>";
        }
        public function update($params){
            $this->name=$params['name'];
            $this->units=$params['units'];
        }
        public function displayAsTableRow(){
            return "<tr>
                <td>$this->id</td>
                <td>$this->name</td>
                <td>$this->units</td>
                <td>
                    <a class='btn btn-warning' href='./properties.php?action=edit&id=$this->id'>Редагувати</a>
                    <a class='btn btn-danger' href='./properties.php?action=delete&id=$this->id'>Видалити</a>
                </td>
            </tr>";
        }
        public function displayAsInput(){
            return "<p>
                <input class='form-control' type='text' name='prop$this->id' placeholder='$this->name ($this->units)' required/>
            </p>";
        }
        public function displayAsInputWithValue($value){
            return "<p>
                <input class='form-control' value='$value' type='text' name='prop$this->id' placeholder='$this->name ($this->units)' required/>
            </p>";
        }
        public function getAsAssociativeArray(){
            return ['id'=>$this->id,'name'=>$this->name, 'units'=>$this->units,];
        }
        public function __destruct(){
            $this->id=null;
            $this->name=null;
            $this->units=null;
        }
    }