<?php
require_once('./app/dbConnect.php');
require_once('./app/Property.php');
require_once('./app/BaseList.php');
class PropertyList extends BaseList{
    public function add($params){
        $newObj=new Property($params);
        array_push($this->list, $newObj);
    }
    public function loadFromDataBase(){
        global $conn;
        $sql = "SELECT * FROM properties";
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $this->add($row);
            }
        } else {
        echo "0 results";
        }
    }
    public function getFromDatabaseByID($id){
        global $conn;
        $sql = "SELECT * FROM properties WHERE id=".$id;
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                return $row;
            }
        } else {
        echo "0 results";
        }
    }
    public function insertIntoDataBase($params){
        global $conn;
        $stmt = $conn->prepare("INSERT INTO properties VALUES (DEFAULT, ?,?)");
        $stmt->bind_param("ss", $params['name'],$params['units']);
        $stmt->execute();
    }
    public function updateInDataBaseById($params){
        global $conn;
        $stmt = $conn->prepare("UPDATE properties SET name=?, units=? WHERE id=?");
        $stmt->bind_param("sss", $params['name'],$params['units'], $params['id']);
        $stmt->execute();
    }
    public function deleteFromDataBaseById($id){
        global $conn;
        $stmt = $conn->prepare("DELETE FROM properties WHERE id=?");
        $stmt->bind_param("s",$id);
        $stmt->execute();
    }
    public function destruct($params){
        global $conn;
        $conn->close();
    }
    public function getAsArray(){
        $array=[];
        for ($i=0;$i<count($this->list);$i++){
                array_push($array,$this->list[$i]->getAsAssociativeArray());
        }
        return $array;
    }
     public function displayAsInputs($bpPropsArray){
        
        $content='';
        for ($i=0;$i<count($this->list);$i++){
            $propertyValue=null;
            if(count($bpPropsArray)>0){
                for ($j=0;$j<count($bpPropsArray);$j++){
                    
                    if($this->list[$i]->getId()==$bpPropsArray[$j]['propertyid']){
                        $propertyValue=$bpPropsArray[$j]['value'];
                    }
                }
            } 
            if($propertyValue!=null){
                $content.=$this->list[$i]->displayAsInputWithValue($propertyValue);
            }else{
                $content.=$this->list[$i]->displayAsInput();
            }
        }
        return $content;
    }
}