<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once('./app/CategoryList.php');
$a=new CategoryList();
$formObj=null;
if($_SERVER['REQUEST_METHOD']=="POST"){
    if($_POST['id']==''){
        $a->insertIntoDataBase(['name'=>$_POST['name']]);
    } else{
        $a->updateInDataBaseById([
            'id'=>$_POST['id'],
            'name'=>$_POST['name']
        ]);
        header('location:./categories.php');
    }
    
} else if($_SERVER['REQUEST_METHOD']=="GET"){
    if(isset($_GET['action'])){
        if($_GET['action']=='delete'){
            $a->deleteFromDataBaseById($_GET['id']);
            header('location:./categories.php');
        } else if($_GET['action']=='edit'){
            $formObj=$a->getFromDataBaseById($_GET['id']);
        }
    }
}
$a->loadFromDataBase();
?>
<html>
    <head>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.8/css/bootstrap.min.css" integrity="sha512-2bBQCjcnw658Lho4nlXJcc6WkV/UxpE/sAokbXPxQNGqmNdQrWqtw26Ns9kFF/yG792pKR1Sx8/Y1Lf1XN4GKA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <meta charset="utf8"/>
        <title>Категорії</title>
    </head>
    <body>
        <div class="container">
            <ul class="nav nav-tab">
                <li class="nav-link"><a href="./categories.php">Категорії</a></li>
                <li class="nav-link"><a href="./properties.php">Властивості</a></li>
                <li class="nav-link"><a href="./backpacks.php">Рюкзаки</a></li>
            </ul>
            <h1>Категорії</h1>
            <div class="row">
                <div class="col-md-8">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Назва</th>
                                <th>Дії</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $a->displayAsTableRows();?>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-4">
                    <form method="POST">
                        <p>
                            <input class="form-control" type='text' value="<?php echo $formObj!=null?$formObj['name']:''; ?>" name='name' placeholder="Введіть назву" required/>
                        </p>
                        <p>
                            <input type="hidden" value="<?php echo $formObj!=null?$formObj['id']:''; ?>" name='id'/>
                            <button class="btn btn-success" type="submit">Зберегти</button>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </body>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.8/js/bootstrap.min.js" integrity="sha512-nKXmKvJyiGQy343jatQlzDprflyB5c+tKCzGP3Uq67v+lmzfnZUi/ZT+fc6ITZfSC5HhaBKUIvr/nTLCV+7F+Q==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
</html>