<?php
require_once('./app/dbConnect.php');
require_once('./app/BaseEntity.php');
    class Backpack extends BaseEntity{
        private $model;
        private $vendor;
        private $price;
        private $categoryid;
        private $categoryname;
        public function __construct($params){
            $this->id=$params['id'];
            $this->model=$params['model'];
            $this->vendor=$params['vendor'];
            $this->price=$params['price'];
            $this->categoryid=$params['categoryid'];
            $this->categoryname=$params['categoryname'];
        }
        public function display(){
            echo "$this->id. $this->vendor $this->model ($this->price)</br>";
        }
        public function update($params){
            $this->model=$params['model'];
            $this->vendor=$params['vendor'];
            $this->price=$params['price'];
            $this->categoryid=$params['categoryid'];
        }
        public function __destruct(){
            $this->id=null;
            $this->model=null;
            $this->vendor=null;
            $this->price=null;
            $this->categoryid=null;
        }
        public function loadPropertiesForBackpackId(){
            global $conn;
            $sql = "SELECT backpackproperties.*,properties.name propname,properties.units propunits FROM backpackproperties
            INNER JOIN properties ON backpackproperties.propertyid=properties.id WHERE backpackid=".$this->id;
            $prop_array=array();
            $result = $conn->query($sql);
            if ($result->num_rows > 0) {
                
                while($row = $result->fetch_assoc()) {
                    array_push($prop_array,$row);
                }
            } else {
                //echo "0 results";
            }
            return $prop_array;
        }
        public function displayAsTableRow(){
            $prop_array=$this->loadPropertiesForBackpackId();
            $propContent='';
            for($i=0;$i<count($prop_array);$i++){
                $propContent.=$prop_array[$i]['propname'].": ".$prop_array[$i]['value'].' '.$prop_array[$i]['propunits']."</br>";
            }
            return "<tr>
                <td>$this->id</td>
                <td>$this->vendor</td>
                <td>$this->model</td>
                <td>$this->price</td>
                <td>$this->categoryname</td>
                <td>$propContent</td>
                <td>
                    <a class='btn btn-warning' href='./backpacks.php?action=edit&id=$this->id'>Редагувати</a>
                    <a class='btn btn-danger' href='./backpacks.php?action=delete&id=$this->id'>Видалити</a>
                </td>
            </tr>";
        }
    }