<?php
require_once('./app/dbConnect.php');
require_once('./app/Backpack.php');
require_once('./app/BaseList.php');
class BackpackList extends BaseList{
    public function add($params){
        $newObj=new Backpack($params);
        array_push($this->list, $newObj);
    }
    
    public function loadFromDataBase(){
        global $conn;
        $sql = "SELECT backpacks.*,categories.name categoryname FROM backpacks
        INNER JOIN categories ON backpacks.categoryid=categories.id";
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $this->add($row);
            }
        } else {
        echo "0 results";
        }
    }
    public function getBackpackPropertiesById($id){
        for ($i=0;$i<count($this->list);$i++){
            if($id==$this->list[$i]->getId()){
                
               return $this->list[$i]->loadPropertiesForBackpackId();
            }
        }
        return [];
    }
    public function getFromDatabaseByID($id){
        global $conn;
        $sql = "SELECT * FROM backpacks WHERE id=".$id;
        $result = $conn->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                return $row;
            }
        } else {
        echo "0 results";
        }
    }
    public function insertIntoDataBase($params){
        global $conn;
        $stmt = $conn->prepare("INSERT INTO backpacks VALUES (DEFAULT, ?,?,?,?)");
        $stmt->bind_param("ssss", $params['model'],$params['vendor'],$params['price'],$params['categoryid']);
        $stmt->execute();
        return $conn->insert_id;
    }
    public function insertPropertyIntoDB($params){
        global $conn;
        $stmt = $conn->prepare("INSERT INTO backpackproperties VALUES (DEFAULT, ?,?,?)");
        $stmt->bind_param("sss", $params['backpackid'],$params['propertyid'],$params['value']);
        $stmt->execute();
    }
    public function updateInDataBaseById($params){
        global $conn;
        $stmt = $conn->prepare("UPDATE backpacks SET model=?, vendor=?, price=?,categoryid=? WHERE id=?");
        $stmt->bind_param("sssss", $params['model'],$params['vendor'],$params['price'],$params['categoryid'], $params['id']);
        $stmt->execute();
    }
    public function deleteFromDataBaseById($id){
        global $conn;
        $stmt = $conn->prepare("DELETE FROM backpacks WHERE id=?");
        $stmt->bind_param("s",$id);
        $stmt->execute();
    }
    public function deletePropertiesFromDataBaseById($id){
        global $conn;
        $stmt = $conn->prepare("DELETE FROM backpackproperties WHERE backpackid=?");
        $stmt->bind_param("s",$id);
        $stmt->execute();
    }
    public function destruct($params){
        global $conn;
        $conn->close();
    }
}