<?php
require_once('./app/BaseEntity.php');
    class Category extends BaseEntity{
        private $name;
        public function __construct($params){
            $this->id=$params['id'];
            $this->name=$params['name'];
        }
        public function display(){
            echo "$this->id. $this->name</br>";
        }
        public function displayAsTableRow(){
            return "<tr>
                <td>$this->id</td>
                <td>$this->name</td>
                <td>
                    <a class='btn btn-warning' href='./categories.php?action=edit&id=$this->id'>Редагувати</a>
                    <a class='btn btn-danger' href='./categories.php?action=delete&id=$this->id'>Видалити</a>
                </td>
            </tr>";
        }
        public function displayAsOption(){
            return "<option value='$this->id'>$this->name</option>";
        }
        public function displayAsActiveOption(){
            return "<option value='$this->id' selected>$this->name</option>";
        }
        public function update($params){
            $this->name=$params['name'];
        }
        public function __destruct(){
            $this->id=null;
            $this->name=null;
        }
    }