<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once('./app/BackpackList.php');
require_once('./app/CategoryList.php');
require_once('./app/PropertyList.php');
$a=new BackpackList();
$a->loadFromDataBase();
$propList=new PropertyList();
$propList->loadFromDataBase();
$propArray=$propList->getAsArray();
$bpPropsArray=null;
$formObj=null;
if($_SERVER['REQUEST_METHOD']=="POST"){
    if($_POST['id']==''){
        $lastid=$a->insertIntoDataBase(['model'=>$_POST['model'],
            'vendor'=>$_POST['vendor'],
            'price'=>$_POST['price'],
            'categoryid'=>$_POST['categoryid']]);
        for($i=0;$i<count($propArray);$i++){
            $a->insertPropertyIntoDB(['backpackid'=>$lastid,'propertyid'=>$propArray[$i]['id'],'value'=>$_POST['prop'.$propArray[$i]['id']]]);
        }
    } else{
        $a->updateInDataBaseById([
            'id'=>$_POST['id'],
            'model'=>$_POST['model'],
            'vendor'=>$_POST['vendor'],
            'price'=>$_POST['price'],
            'categoryid'=>$_POST['categoryid']
        ]);
        $a->deletePropertiesFromDataBaseById($_POST['id']);
        for($i=0;$i<count($propArray);$i++){
            $a->insertPropertyIntoDB(['backpackid'=>$_POST['id'],'propertyid'=>$propArray[$i]['id'],'value'=>$_POST['prop'.$propArray[$i]['id']]]);
        }
        header('location:./backpacks.php');
    }
    
} else if($_SERVER['REQUEST_METHOD']=="GET"){
    if(isset($_GET['action'])){
        if($_GET['action']=='delete'){
            $a->deleteFromDataBaseById($_GET['id']);
            header('location:./backpacks.php');
        } else if($_GET['action']=='edit'){
            $formObj=$a->getFromDataBaseById($_GET['id']);
            $bpPropsArray=$a->getBackpackPropertiesById($_GET['id']);
        }
    }
}

$catList=new CategoryList();
$catList->loadFromDataBase();

?>
<html>
    <head>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.8/css/bootstrap.min.css" integrity="sha512-2bBQCjcnw658Lho4nlXJcc6WkV/UxpE/sAokbXPxQNGqmNdQrWqtw26Ns9kFF/yG792pKR1Sx8/Y1Lf1XN4GKA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <meta charset="utf8"/>
        <title>Рюкзаки</title>
    </head>
    <body>
        <div class="container">
            <ul class="nav nav-tab">
                <li class="nav-link"><a href="./categories.php">Категорії</a></li>
                <li class="nav-link"><a href="./properties.php">Властивості</a></li>
                <li class="nav-link"><a href="./backpacks.php">Рюкзаки</a></li>
            </ul>
            <h1>Рюкзаки</h1>
            <div class="row">
                <div class="col-md-8">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Виробник</th>
                                <th>Модель</th>
                                <th>Ціна</th>
                                <th>Категорія</th>
                                <th>Характеристики</th>
                                <th>Дії</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $a->displayAsTableRows();?>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-4">
                    <form method="POST">
                        <p>
                            <input class="form-control" type='text' 
                            value="<?php echo $formObj!=null?$formObj['vendor']:''; ?>" 
                            name='vendor' placeholder="Введіть виробника" required/>
                        </p>
                        <p>
                            <input class="form-control" type='text' 
                            value="<?php echo $formObj!=null?$formObj['model']:''; ?>" 
                            name='model' placeholder="Введіть модель" required/>
                        </p>
                        <p>
                            <input class="form-control" type='number' 
                            value="<?php echo $formObj!=null?$formObj['price']:''; ?>" 
                            name='price' placeholder="Введіть ціну" required/>
                        </p>
                        <p>
                            <select class="form-select" name='categoryid'><?php echo $catList->displayAsOptions($formObj!=null?$formObj['categoryid']:'');?> </select>
                        </p>
                        <?php echo $propList->displayAsInputs($bpPropsArray!=null?$bpPropsArray:[]);?>
                        <p>
                            <input type="hidden" value="<?php echo $formObj!=null?$formObj['id']:''; ?>" name='id'/>
                            <button class="btn btn-success" type="submit">Зберегти</button>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </body>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.8/js/bootstrap.min.js" integrity="sha512-nKXmKvJyiGQy343jatQlzDprflyB5c+tKCzGP3Uq67v+lmzfnZUi/ZT+fc6ITZfSC5HhaBKUIvr/nTLCV+7F+Q==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
</html>