<?php
require_once('BaseEntity.php');
require_once('DBConnect.php');
class Backpack extends BaseEntity{
    private $model;
    private $vendor;
    private $price;
    private $categoryid;
    private $categoryname;
    public function __construct($id, $model,$vendor,$price,$categoryid,$categoryname){
        $this->id=$id;
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->categoryid=$categoryid;
        $this->categoryname=$categoryname;
    }
    public function display(){
        echo $this->id.". ".$this->vendor." ".$this->model."</br>";
        echo "Категорія: <i>".$this->categoryid."</i></br>";
        echo "Ціна: <b>".$this->price."</b> грн</br>";
    }
    public function update($model,$vendor,$price,$categoryid){
        $this->model=$model;
        $this->vendor=$vendor;
        $this->price=$price;
        $this->categoryid=$categoryid;
    }
    public function __destruct(){
        $this->id=null;
        $this->model=null;
        $this->vendor=null;
        $this->price=null;
        $this->categoryid=null;
    }
    public function getAsJSON(){
        return '{
            "id": "'.$this->id.'",
            "model": "'.$this->model.'",
            "vendor": "'.$this->vendor.'",
            "price": "'.$this->price.'",
            "categoryid": "'.$this->categoryid.'"
        }';
    }
    public function getAsXML(){
        return '<backpack>
                    <id>'.$this->id.'</id>
                    <model>'.$this->model.'</model>
                    <vendor>'.$this->vendor.'</vendor>
                    <price>'.$this->price.'</price>
                    <category>'.$this->categoryid.'</category>
                </backpack>';
    }
    public function getAsAssociativeArray(){
        return [
                'id'=>$this->id,
                'model'=>$this->model,
                'vendor'=>$this->vendor,
                'price'=>$this->price,
                'categoryid'=>$this->categoryid,
                ];
    }
    public function getBackpackProperties(){
        global $conn;
        $stmt = $conn->prepare("SELECT backpackproperties.*, properties.name, properties.units FROM backpackproperties
        INNER JOIN properties ON properties.id=backpackproperties.propertyid WHERE backpackid=?");
        $stmt->bind_param("s", $this->id);
        $stmt->execute();
        $result = $stmt->get_result();
        $array=[];
        if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            array_push($array,$row);
        }
        } 
        return $array;
    }
    public function getAsTableRow(){
        $propArray=$this->getBackpackProperties();
        $propertiesContent='';
        for($i=0;$i<count($propArray);$i++){
            $propertiesContent.=$propArray[$i]['name'].': '.$propArray[$i]['value'].' '.$propArray[$i]['units'].'</br>';
        }
        return '<tr>
                    <td>'.$this->id.'</td>
                    <td>'.$this->model.'</td>
                    <td>'.$this->vendor.'</td>
                    <td>'.$this->categoryname.'</td>
                    <td>'.$this->price.'</td>
                    <td>'.$propertiesContent.'</td>
                    <td>
                        <a class="btn btn-warning" href="./backpacks.php?action=update&id='.$this->id.'">Редагувати</a>
                        <a class="btn btn-danger" href="./backpacks.php?action=delete&id='.$this->id.'">Видалити</a>
                    </td>
                </tr>';
    }
    public function getAsIndexedArray(){
        return [$this->model,$this->vendor,$this->price,$this->categoryid];
    }
}