<?php
require_once('BaseList.php');
require_once('Backpack.php');
require_once('DBConnect.php');
class BackpackList extends BaseList{
    public function add($params){
        $elem=new Backpack($params['id'],$params['model'],$params['vendor'],$params['price'],$params['categoryid'],$params['categoryname']);
        array_push($this->list, $elem);
    }
    public function update($params){
        for ($i=0;$i<count($this->list);$i++){
            if($this->list[$i]->getId()==$params['id']){
                $this->list[$i]->update($params['model'],$params['vendor'],$params['price'],$params['categoryid']);
                break;
            }
        }
    }
    public function getAsJSON(){
        $content='{
    "backpacks": [';
        for ($i=0;$i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsJSON().",";
        }
        $content = substr($content, 0, -1);
        $content.='    ]
        }';
        return $content;
    }
    public function getAsXML(){
        $content='<backpacks>
        ';
        for ($i=0;$i<count($this->list);$i++){
            $content.=$this->list[$i]->getAsXML();
        }
        $content.='</backpacks>';
        return $content;
    }
    public function readFromCSV($filePath){
        $fp = fopen($filePath, 'r');
        if ($fp === false) {
            die('Error: Cannot open the CSV file.');
        }
        while (($row = fgetcsv($fp,10000,",","`","\\")) !== false) {
            $this->add(['model'=>$row[0], 'vendor'=>$row[1],'price'=>$row[2],'categoryid'=>$row[3]]);
        }
        fclose($fp);
    }
    public function getAllFromDatabase(){
        global $conn;
        $sql = "SELECT backpacks.*, categories.name categoryname FROM backpacks
        INNER JOIN categories ON categories.id=backpacks.categoryid";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            $this->add($row);
        }
        }
    }
    public function getAllFromDatabaseById($id){
        global $conn;
        $stmt = $conn->prepare("SELECT backpacks.*, categories.name categoryname FROM backpacks
        INNER JOIN categories ON categories.id=backpacks.categoryid WHERE id=?");
        $stmt->bind_param("s", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            return $row;
        }
        } else{
            return null;
        }
    }
    public function addBackpackProperty($backpackid,$propertyid,$value){
        global $conn;
        $stmt = $conn->prepare("INSERT INTO backpackproperties VALUES (DEFAULT, ?,?,?)");
        $stmt->bind_param("sss", $backpackid,$propertyid, $value);
        $stmt->execute();
        return $conn->insert_id;
    }
    public function updateBackpackProperty($backpackid,$propertyid,$value){
        global $conn;
        $stmt = $conn->prepare("UPDATE `backpackproperties` SET `value`=? WHERE `backpackid`=? and `propertyid`=?;");
        $stmt->bind_param("sss", $value,$backpackid,$propertyid);
        $stmt->execute();
    }
    public function insertIntoDatabase($params){
        global $conn;
        $stmt = $conn->prepare("INSERT INTO backpacks VALUES (DEFAULT, ?,?,?,?)");
        $stmt->bind_param("ssss", $params['vendor'],$params['model'],$params['price'],$params['categoryid']);
        $stmt->execute();
        return $conn->insert_id;
    }
    public function updateDatabaseById($params){
        global $conn;
        $stmt = $conn->prepare("UPDATE `backpacks` SET `vendor`=?, `model`=?,`price`=?, `categoryid`=? WHERE `id`=?;");
        $stmt->bind_param("sssss", $params['vendor'],$params['model'],$params['price'],$params['categoryid'],$params['id']);
        $stmt->execute();
    }
    public function deleteFromDatabaseById($id){
        global $conn;
        $stmt = $conn->prepare("DELETE FROM backpacks WHERE id=?");
        $stmt->bind_param("s", $id);
        $stmt->execute();
    }
    public function getBackpackPropertiesById($id){
        for ($i=0;$i<count($this->list);$i++){
            if($this->list[$i]->getId()==$id){
                return $this->list[$i]->getBackpackProperties();
            }
        }
    }
}