<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
if(!$_SESSION['user']){
    header('Location: login.php');
}
require_once('../app/BackpackList.php');
require_once('../app/CategoryList.php');
require_once('../app/PropertyList.php');
$catList=new CategoryList();
$catList->getAllFromDatabase();
$propList=new PropertyList();
$propList->getAllFromDatabase();
$propArray=$propList->getAsAssocArray();
$a = new BackpackList();
$item=null;
$itemProps=[];
if($_SERVER['REQUEST_METHOD']=='POST'){
    if($_POST['id']==""){
        $backpackid=$a->insertIntoDatabase(['vendor'=>$_POST['vendor'], 
        'model'=>$_POST['model'],
        'categoryid'=>$_POST['categoryid'], 
        'price'=>$_POST['price'],
]);
    for ($i=0;$i<count($propArray);$i++){
        if(isset($_POST['prop-'.$propArray[$i]['id']])){
            $a->addBackpackProperty($backpackid,$propArray[$i]['id'],$_POST['prop-'.$propArray[$i]['id']]);
        }
    }
    } else{
        $propArray=$propList->getAsAssocArray();
        $a->updateDatabaseById(['id'=>$_POST['id'],
        'vendor'=>$_POST['vendor'], 
        'model'=>$_POST['model'],
        'categoryid'=>$_POST['categoryid'], 
        'price'=>$_POST['price']]);
        for ($i=0;$i<count($propArray);$i++){
        if(isset($_POST['prop-'.$propArray[$i]['id']])){
            
            $a->updateBackpackProperty($_POST['id'],$propArray[$i]['id'],$_POST['prop-'.$propArray[$i]['id']]);
        }
        }    
       
    }
 header('Location: backpacks.php');
} else{
    if(isset($_GET['search'])){
        $a->getAllFromDatabaseBySearchCriteria($_GET['search']);
    }else{
        $a->getAllFromDatabase();
    }
    if(isset($_GET['action'])&&$_GET['action']=='delete'){
        $a->deleteFromDatabaseById($_GET['id']);
        header('Location: backpacks.php');
    } else if(isset($_GET['action'])&&$_GET['action']=='update'){
        $item=$a->getById($_GET['id']);
        $itemProps=$a->getBackpackPropertiesById($_GET['id']);
    }
    
}
?>
<html>
    <head>
        <meta charset="utf-8"/>
        <title>Рюкзаки</title>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">    
    </head>
    <body>
        <div class="container">
            <ul class="nav">
                <li><a class="btn btn-outline nav-btn" href="./categories.php">Категорії</a></li>
                <li><a class="btn btn-outline nav-btn" href="./properties.php">Характеристики</a></li>
                <li><a class="btn btn-outline nav-btn" href="./backpacks.php">Рюкзаки</a></li>
                <li><a class="btn btn-outline nav-btn" href="./logout.php">Вийти</a></li>
            </ul>
            <h1>Рюкзаки</h1>
            <div class="row">
                <div class="col-md-8">
                    <form method="GET">
                        <input type="text" required name="search" placeholder="Шукати"/>
                        <button type="submit" class="btn btn-primary">Пошук</button>
                    </form>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Виробник</th>
                                <th>Модель</th>
                                <th>Категорія</th>
                                <th>Ціна</th>
                                <th>Характеристики</th>
                                <th>Дії</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $a->getAsTableBody();?>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-4">
                    <form method="POST">
                        <p>
                            <input type="text" name="vendor" value="<?php echo $item?$item['vendor']:'';?>" class="form-control" placeholder="Виробник" required/>
                        </p>
                        <p>
                            <input type="text" name="model" value="<?php echo $item?$item['model']:'';?>" class="form-control" placeholder="Модель" required/>
                        </p>
                        <p>
                            <select name="categoryid" class="form-select" placeholder="Категорія" required><?php echo $catList->getAsSelectOptions($item?$item['categoryid']:'');?></select>
                        </p>
                        <p>
                            <input type="text" name="price" value="<?php echo $item?$item['price']:'';?>" class="form-control" placeholder="Ціна" required/>
                        </p>
                        <?php echo $propList->getAsInputGroup($itemProps); ?>
                        <p>
                            <input type="hidden" name="id" value="<?php echo $item?$item['id']:'';?>"/>
                            <button class="btn btn-success" type="submit">Зберегти</button>
                        </p>
                    </form>
                </div>
            </div>
        </div>
    </body>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>
</html>