import { useState,useEffect } from 'react';
function PlaceForm(props) {
  //console.log(props);
    
    let form_display_style={};
    let handleCancelClick = ()=>{
      props.form_visibility_changer(false);
    }
    let handleSaveClick = ()=>{
      if(props.form_data.id){
        let edited_array=props.places_array;
        for (let i=0;i<edited_array.length;i++){
          if (edited_array[i].id==props.form_data.id){
            edited_array[i]=props.form_data;
          }
        }
        props.places_array_changer(edited_array);
      } else{
        let newid=1;
        if(props.places_array.length>1 ){
          newid=props.places_array[props.places_array.length-1].id+1;
        }
        let newPlace={...props.form_data,id:newid}
        props.places_array_changer([...props.places_array,newPlace])
      }
      props.set_form_data({id:undefined,name:"",description:"",image_url:""})
      props.form_visibility_changer(false);
    }
    const handleChange = (event) => {
      const value = event.target.value;
      //console.log(props.form_data);
      props.set_form_data({
        ...props.form_data,
        [event.target.name]: value
      });
    };
    if(props.isused){
      form_display_style={display:"flex"};
    } else{
      form_display_style={display:"none"};
    }
    useEffect(() => {
      return () => {
      };
    }, []);
    return (
      <form className="place-form" style={form_display_style}>
        <label htmlFor="name">Place Name</label>
        <input type="text" name="name" onChange={handleChange} value={props.form_data.name} placeholder="Enter name" />
        <label htmlFor="description">Description</label>
        <textarea name="description" onChange={handleChange} value={props.form_data.description} placeholder="Enter description" />
        <label htmlFor="image_url">Place Photo URL</label>
        <input type="text" name="image_url" onChange={handleChange} value={props.form_data.image_url} placeholder="Enter image url" />
        <div className="input-group">
          <button onClick={(event)=>{
            event.preventDefault();
            handleSaveClick();
            }}>Save</button>
          <button onClick={(event)=>{
            event.preventDefault();
            handleCancelClick();
            }}>Cancel</button>
        </div>
      </form>
    );
  }
  
  export default PlaceForm;