import {NavLink} from 'react-router-dom'; 
function PlaceItem(props) {
    let placesApiUrl="http://localhost:4000/places";
    
    let handleEditClick = (place)=>{
        props.form_visibility_changer(true);
        //console.log('Edit button clicked! Place affected: ');
        props.set_form_data(place);
        //console.log(place);
    }
    let handleDeleteClick = (place)=>{
        console.log('Delete button clicked! Place affected: ');
        fetch(placesApiUrl+"/"+place.id,{
            method: "DELETE"
          }).then((response) => {
            let filteredArray=props.places_array.filter(function(elem){
                return elem.id!=place.id;
            });
            props.places_array_changer(filteredArray);
          });
        
        //console.log(place);
    }
    let place=props.itemdata;
    return (
        <div key={place.id} className='place-item'>
            <h3>{place.name}</h3>
            <p>{place.description}</p>
            <NavLink to={"/places/"+place.id}>View place info</NavLink>
            <img src={place.image_url}/>
            <div className="item-button-block">
                <button onClick={()=>{handleEditClick(place);}}>Edit</button>
                <button onClick={()=>{handleDeleteClick(place);}}>Delete</button>
            </div>
        </div>
    );
  }
  
  export default PlaceItem;