import {BrowserRouter as Router, Routes, Route, NavLink} from 'react-router-dom';
import { useState,useEffect } from 'react';
import './App.css';
import GeneralInfo from './components/GeneralInfo';
import PlaceForm from './components/PlaceForm';
import ViewItem from './components/ViewItem';
import PlacesToVisit from './components/PlacesToVisit';
import NavigationPanel from './components/NavigationPanel';
import AboutPage from './components/AboutPage';

function App() {
  const [isFormUsed, setIsFormUsed] = useState(false);
  const [placesData, setPlaceData]=useState([]);
  const [formData,setFormData]=useState({id:undefined,name:"",description:"",image_url:""});
  let placesApiUrl="http://localhost:4000/places";
  useEffect(() => {
    fetch(placesApiUrl).then((response) => response.json())
    .then((data) => setPlaceData(data));
    return () => {
    };
  }, []);
  return (
    <div className="App">
      <Router>
        <NavigationPanel/>
        <Routes>
          <Route path="/" element={<GeneralInfo/>} />
          <Route path="/places" element={
          <div>
            <PlacesToVisit form_data={formData} set_form_data={setFormData} places_array={placesData} places_array_changer={setPlaceData} form_visibility_changer={setIsFormUsed} />
            <PlaceForm form_data={formData} set_form_data={setFormData} places_array={placesData} places_array_changer={setPlaceData} isused={isFormUsed} form_visibility_changer={setIsFormUsed}/>
          </div>} />
          <Route path="/about" element={<AboutPage/>} />
          <Route path="/places/:id" element={<ViewItem places={placesData} />} />
        </Routes>
        
        
        
      </Router>
    </div>
  );
}

export default App;
