<?php
abstract class Operation {
	protected $data;
    public function __construct($data) {
    	$this->data = $data;
  	}
    public function set_data($data){
    	$this->data = $data;
    }
    public function get_data($data){
    	return $this->data;
    }
    function __destruct() {
  }
    abstract public function calc_stats();
}
class Mean extends Operation {
	public function calc_stats(){
    	$avg_value=0;
        foreach ($this->data as $array_elem){
          $avg_value+=$array_elem;
        }
        $avg_value/=count($this->data);
        return $avg_value;
    }
}
class Dispersion extends Operation {
	public function calc_stats(){
    	$avg_value=0;
        foreach ($this->data as $array_elem){
          $avg_value+=$array_elem;
        }
        $avg_value/=count($this->data);
        $disp_value=0;
        foreach ($this->data as $array_elem){
          $disp_value+=($array_elem-$avg_value)**2;
        }
        $disp_value/=count($this->data);
        return $disp_value;
    }
}
class Median extends Operation {
	public function calc_stats(){
    	$sorted_arr=$this->data;
        sort($sorted_arr);
        if(count($sorted_arr)%2==1){
        	return $sorted_arr[floor(count($sorted_arr)/2)];
        } else{
        	return ($sorted_arr[count($sorted_arr)/2]+$sorted_arr[count($sorted_arr)/2-1])/2;
        }
    }
}

$inputfile = fopen("input.txt", "r") or die("Unable to open file!");
$outputfile = fopen("output.txt", "w") or die("Unable to open file!");
// Output one line until end-of-file
while(!feof($inputfile)) {
  $fileline=fgets($inputfile);
  $param_array=explode(", ", $fileline);
  $data_array=explode(" ", substr($param_array[1], 0, -1));
  $newop=NULL;
  if($param_array[0]=='mean'){
  	$newop= new Mean($data_array);
  	fwrite($outputfile, "Mean of operation with array (".implode(" ",$data_array).") equals to ".$newop->calc_stats());
  } else if($param_array[0]=='dispersion'){
  	$newop= new Dispersion($data_array);
  	fwrite($outputfile, "Dispersion of operation with array (".implode(" ",$data_array).") equals to ".$newop->calc_stats());
  } else if($param_array[0]=='median'){
  	$newop= new Median($data_array);
  	fwrite($outputfile, "Median of operation with array (".implode(" ",$data_array).") equals to ".$newop->calc_stats());
  }
  fwrite($outputfile,"\n");
}
fclose($inputfile);
fclose($outputfile);
?>

