<?php
session_start();
  if(isset($_SESSION['username'])){
    echo "logged in as ". $_SESSION['username'];
 } else{
    header("Location: login.php");
    }
    abstract class Operation {
        protected $data;
        public function __construct($data) {
            $this->data = $data;
          }
        public function set_data($data){
            $this->data = $data;
        }
        public function get_data($data){
            return $this->data;
        }
        function __destruct() {
      }
        abstract public function calc_stats();
    }
    class Mean extends Operation {
        public function calc_stats(){
            $avg_value=0;
            foreach ($this->data as $array_elem){
              $avg_value+=$array_elem;
            }
            $avg_value/=count($this->data);
            return $avg_value;
        }
    }
    class Dispersion extends Operation {
        public function calc_stats(){
            $avg_value=0;
            foreach ($this->data as $array_elem){
              $avg_value+=$array_elem;
            }
            $avg_value/=count($this->data);
            $disp_value=0;
            foreach ($this->data as $array_elem){
              $disp_value+=($array_elem-$avg_value)**2;
            }
            $disp_value/=count($this->data);
            return $disp_value;
        }
    }
    class Median extends Operation {
        public function calc_stats(){
            $sorted_arr=$this->data;
            sort($sorted_arr);
            if(count($sorted_arr)%2==1){
                return $sorted_arr[floor(count($sorted_arr)/2)];
            } else{
                return ($sorted_arr[count($sorted_arr)/2]+$sorted_arr[count($sorted_arr)/2-1])/2;
            }
        }
    }

    $servername = "localhost";
    $username = "root";
    $password = "Q!W@E#r4t5y6";
    $database = "phplab";
    // Create connection
    $conn = new mysqli($servername, $username, $password, $database);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    //create options for select
    $sql = "SELECT id, name FROM operations;";
    $result = $conn->query($sql);
    $operation_options="";
    if ($result->num_rows > 0) {
    // output data of each row
        while($row = $result->fetch_assoc()) {
            $operation_options.="<option value='".$row['id']."'>".$row['name']."</option>";
        }
    }
    //check if this is deletion
    if(isset($_GET['deleteid'])){
        $sql = "DELETE FROM data WHERE id=".$_GET['deleteid'].";";
        $result = $conn->query($sql);
    }
    // check if data were added
    if(isset($_POST['opdata'])){
        $data_array=explode(" ", $_POST['opdata']);
        $newop=NULL;
        if($_POST['optype']==1){
            $newop= new Mean($data_array);
        } else if($_POST['optype']==2){
            $newop= new Dispersion($data_array);
            
        } else if($_POST['optype']==3){
            $newop= new Median($data_array);
        }
        $sql = "INSERT INTO `data` VALUES (DEFAULT, '".$_POST['optype']."', '".$_POST['opdata']."', '".$newop->calc_stats()."');";
        $conn->query($sql);
    }
    
    // read data from DB table
    $sql = "SELECT `data`.id, `operations`.name, `data`.inputdata, `data`.outputdata FROM data INNER JOIN operations ON `operations`.id=`data`.operationid;";
    $result = $conn->query($sql);
    $table_body="";
    if ($result->num_rows > 0) {
    // output data of each row
        while($row = $result->fetch_assoc()) {
            $table_body.="<tr><td>".$row['id']."</td><td>".$row['name']."</td><td>".$row['inputdata']."</td><td>".$row['outputdata']."</td><td><a href='test.php?deleteid=".$row['id']."'>Delete</a></td></tr>";
        }
    }
    
    $conn->close();
?>
<html>
    <head>
        <title>Lab 7</title>
    </head>
    <body>
        <form method="POST" action="test.php">
            <p>
                <label for="optype">Select operation type:</label>
            </p>
            <p>
                <select name="optype">
                    <?php echo $operation_options; ?>
                </select>
            </p>
            <p>
                <label for="opdata">Enter array with elements separated by space:</label>
            </p>
            <p>
                <input type="text" name="opdata" required>
            </p>
            <p>
                <input type="submit" value="Send data">
            </p>
        </form>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Operation</th>
                    <th>Input</th>
                    <th>Output</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php echo $table_body; ?>
            </tbody>
        </table>
    </body>
</html>
