<?php
    function mct_add_theme_scripts() {
        wp_enqueue_style( 'style', get_stylesheet_uri() );
        wp_enqueue_style( 'fonts', get_template_directory_uri() . '/assets/fonts.css', array(), '1.0', 'all');
    }
    add_action( 'wp_enqueue_scripts', 'mct_add_theme_scripts' );
    function mct_register_menus() {
        register_nav_menu('header-menu',__( 'Header Menu' ));
        register_nav_menu('sidebar-menu',__( 'Sidebar Menu' ));
      }
    add_action( 'init', 'mct_register_menus' );
    function wpb_widgets_init() {
 
        register_sidebar( array(
            'name'          => 'Footer Widget Area 1',
            'id'            => 'footer-widget-1',
            'before_widget' => '<div id="box1">',
            'after_widget'  => '</div>',
            'before_title'  => '<div class="title"><h2>',
            'after_title'   => '</h2></div>',
        ) );
        register_sidebar( array(
            'name'          => 'Footer Widget Area 2',
            'id'            => 'footer-widget-2',
            'before_widget' => '<div id="box2">',
            'after_widget'  => '</div>',
            'before_title'  => '<div class="title"><h2>',
            'after_title'   => '</h2></div>',
        ) );
        register_sidebar( array(
            'name'          => 'Footer Widget Area 3',
            'id'            => 'footer-widget-3',
            'before_widget' => '<div id="box3">',
            'after_widget'  => '</div>',
            'before_title'  => '<div class="title"><h2>',
            'after_title'   => '</h2></div>',
        ) );
     
    }
    add_action( 'widgets_init', 'wpb_widgets_init' );
    function mct_customize_register( $wp_customize ) {

        $wp_customize->add_section( 'mct_options_section' , array(
            'title'      => __( 'Theme Options', 'theme_options' ),
            'priority'   => 30,
        ));
    
        $wp_customize->add_setting( 'header-image', array());
        $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'mct_header_image_control', array(
            'label' => 'Upload Header Image',
            'priority' => 20,
            'section' => 'mct_options_section',
            'settings' => 'header-image',
            'button_labels' => array(// All These labels are optional
                        'select' => 'Select Image',
                        'remove' => 'Remove Image',
                        'change' => 'Change Image',
                        )
        )));
    
        // ..repeat ->add_setting() and ->add_control() for mytheme_company-division
    }
    add_action( 'customize_register', 'mct_customize_register' );
?>