<?php
abstract class Operation {
	protected $data;
    public function __construct($data) {
    	$this->data = $data;
  	}
    public function set_data($data){
    	$this->data = $data;
    }
    public function get_data($data){
    	return $this->data;
    }
    abstract public function calc_stats() :float;
}
class Mean extends Operation {
	public function calc_stats():float{
    	$avg_value=0;
        foreach ($this->data as $array_elem){
          $avg_value+=$array_elem;
        }
        $avg_value/=count($this->data);
        return (float)$avg_value;
    }
}
class Dispersion extends Operation {
	public function calc_stats():float{
    	$avg_value=0;
        foreach ($this->data as $array_elem){
          $avg_value+=$array_elem;
        }
        $avg_value/=count($this->data);
        $disp_value=0;
        foreach ($this->data as $array_elem){
          $disp_value+=($array_elem-$avg_value)**2;
        }
        $disp_value/=count($this->data);
        return (float)$disp_value;
    }
}
class Median extends Operation {
	public function calc_stats():float{
    	$sorted_arr=$this->data;
        sort($sorted_arr);
        if(count($sorted_arr)%2==1){
        	return (float)$sorted_arr[floor(count($sorted_arr)/2)];
        } else{
        	return (float)($sorted_arr[count($sorted_arr)/2]+$sorted_arr[count($sorted_arr)/2-1])/2;
        }
    }
}