<?php 
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
require_once './plugins/PHPMailer/Exception.php';
require_once './plugins/PHPMailer/PHPMailer.php';
require_once './plugins/PHPMailer/SMTP.php';
class EmailSender {
    private $mailer;
    public function __construct($mailserver, $maillogin, $mailpassword){
        $this->mailer = new PHPMailer(true);
        $this->mailer->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
        $this->mailer->isSMTP();                                            //Send using SMTP
        $this->mailer->Host       = $mailserver;                     //Set the SMTP server to send through
        $this->mailer->SMTPAuth   = true;                                   //Enable SMTP authentication
        $this->mailer->Username   = $maillogin;                     //SMTP username
        $this->mailer->Password   = $mailpassword;                               //SMTP password
        $this->mailer->SMTPSecure = "ssl";
        $this->mailer->Port       = 465; 
    }
    public function sendmail($from,$to,$subject,$body){
        try {
            
            //Recipients
            $this->mailer->setFrom($from, '');
            $this->mailer->addAddress($to, '');     //Add a recipient
        
            //Content
            $this->mailer->isHTML(true);                                  //Set email format to HTML
            $this->mailer->Subject = $subject;
            $this->mailer->Body    = $body;
        
            $this->mailer->send();
            echo 'Message has been sent';
        } catch (Exception $e) {
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
        }
    }
}
