var users=[];
var table;
table=$('#dataTable').DataTable({
"lengthMenu": [ 5,10,20 ]
});
jQuery.each( [ "put", "delete" ], function( i, method ) {
  jQuery[ method ] = function( url, data, callback, type ) {
    if ( jQuery.isFunction( data ) ) {
      type = type || callback;
      callback = data;
      data = undefined;
    }
    return jQuery.ajax({
      url: url,
      type: method,
      dataType: type,
      data: data,
      success: callback
    });
  };
});
function User(id, name, username, email, phone, website) {
  this.id = id;
  this.name = name;
  this.username = username;
  this.email = email;
  this.website = website;
  this.phone = phone;
  this.printAsTableRow = function() {
    return `<tr class="data-row" data-number="`+this.id+`">
        <td>`+this.id+`</td>
        <td>`+this.name+`</td>
        <td>`+this.username+`</td>
        <td>`+this.email+`</td>
        <td>`+this.phone+`</td>
        <td>`+this.website+`</td>
        <td><button data-number="`+this.id+`" class="edit btn btn-warning">Edit</button><button data-number="`+this.id+`" class="delete btn btn-danger">Delete</button></td>
      </tr>
      `;
  }
  this.updateUser=function(name, username, email, phone, website){
    this.name = name;
    this.username = username;
    this.email = email;
    this.website = website;
    this.phone = phone;
  }
}
function displayTable(){
  //console.log(users[0].printAsTableRow());
  table.destroy();
  $(".data-row").remove();
  for(i=0;i<users.length;i++){
    $("tbody").append(users[i].printAsTableRow());
  }
  table=$('#dataTable').DataTable({
  "lengthMenu": [ 5,10,20 ]
  });
}
function deleteUser(id){
      users =  users.filter(function(user) {
	   return user.id != id;
  });

}
$(document).ready(function(){
  $.get('https://jsonplaceholder.typicode.com/users',function(data){
    console.log(data);
    for(i=0;i<data.length;i++){
      var newUser=new User (data[i]['id'],data[i]['name'],data[i]['username'],data[i]['email'],data[i]['phone'],data[i]['website']);
      users.push(newUser);
    }
    displayTable();

  });
  $(document).on("click",".delete",function(e){
    e.preventDefault();
    $('#confirm-delete').modal('show');
    console.log($(this).data("number"));
    $("#deleteBtn").attr("data-number",$(this).data("number"));
  });
  $(document).on("click","#deleteBtn",function(e){
    e.preventDefault();
    $("#confirm-delete").modal("hide");
    $.ajax({
      url: 'https://jsonplaceholder.typicode.com/users/'+$(this).attr("data-number"),
      type: 'DELETE',
      success: function(result) {
          alert("User was deleted");
      }
    });
    deleteUser($(this).data("number"));
    displayTable();
  });

  $(document).on("click",".edit",function(e){
    e.preventDefault();
    $("#nameInput").val($(this).parent().parent().children().eq(1).text());
    $("#usernameInput").val($(this).parent().parent().children().eq(2).text());
    $("#emailInput").val($(this).parent().parent().children().eq(3).text());
    $("#phoneInput").val($(this).parent().parent().children().eq(4).text());
    $("#websiteInput").val($(this).parent().parent().children().eq(5).text());
    $("#actionInput").val("edit");
    $("#rownumInput").val($(this).parent().parent().data("number"));
  });
  $(document).on("submit","#inputForm", function(e){
    e.preventDefault();
    if($("#actionInput").val()=="add"){
      $.post("https://jsonplaceholder.typicode.com/users/",
      {
        name:$("#nameInput").val(),
        username:$("#usernameInput").val(),
        email:$("#emailInput").val(),
        phone:$("#phoneInput").val(),
        website:$("#websiteInput").val()
      },
      function(data){
        var newUser=new User (data['id'],data['name'],data['username'],data['email'],data['phone'],data['website']);
        users.push(newUser);
        displayTable();
      }
    );

    } else if($("#actionInput").val()=="edit"){

      $.put('https://jsonplaceholder.typicode.com/users/'+$("#rownumInput").val(),
      {
        name:$("#nameInput").val(),
        username:$("#usernameInput").val(),
        email:$("#emailInput").val(),
        phone:$("#phoneInput").val(),
        website:$("#websiteInput").val()
      },
      function(data){
        let obj = users.find((o, i) => {
          if (o.id ==$("#rownumInput").val()) {
              users[i].updateUser(data['name'],data['username'],data['email'],data['phone'],data['website']);
              return true;
          }
        });
        displayTable();
      }
    );
    }
    $("#inputForm")[0].reset();
    $("#actionInput").val("add");
  });
});