const header=document.getElementById('pageHeader');
const categoryForm = document.getElementById("categoryForm");
const propertyForm = document.getElementById("propertyForm");
const backpackForm = document.getElementById("backpackForm");
function getCategoryData(){
    header.innerText="Категорії";
    [].forEach.call(document.querySelectorAll('.app-form'), function (el) {
        el.style.display = 'none';
      });
    categoryForm.style.display='block';
    fetch('http://localhost/lab/app/api/categoryController.php')
    .then((response) => {
        return response.json();
    })
    .then((data) => {
        //console.log(data);
        let content=``;
        let selectContent=``; 
        for (i=0;i<data.length;i++){
            content+=`<tr><td>`+data[i].id+`</td><td>`+data[i].name+`</td></tr>`;
            selectContent+=`<option value="`+data[i].name+`">`+data[i].name+`</option>`;
        }
        let table=document.getElementById('contentTable');
        table.innerHTML=`<thead>
                            <th>ID</th>
                            <th>Назва</th>
                            </thead>
                            <tbody>
                            `+content+`
                            </tbody>`;
        let categorySelect=document.getElementById('inputBackpackCategory'); 
        categorySelect.innerHTML=selectContent;                                                              
    });
}
function getPropertyData(){
    header.innerText="Властивості";
    [].forEach.call(document.querySelectorAll('.app-form'), function (el) {
        el.style.display = 'none';
      });
    propertyForm.style.display='block';
    fetch('http://localhost/lab/app/api/propertyController.php')
    .then((response) => {
        return response.json();
    })
    .then((data) => {
        //console.log(data);
        let content=``;
        for (i=0;i<data.length;i++){
            content+=`<tr><td>`+data[i].id+`</td><td>`+data[i].name+`</td><td>`+data[i].units+`</td></tr>`;
        }
        let table=document.getElementById('contentTable');
        table.innerHTML=`<thead>
                        <th>ID</th>
                        <th>Назва</th>
                        <th>Одиниці вимірювання</th>
                        </thead>
                        <tbody>
                            `+content+`
                        </tbody>`;
    });
}
function getBackpackData(){
    header.innerText="Рюкзаки";
    [].forEach.call(document.querySelectorAll('.app-form'), function (el) {
        el.style.display = 'none';
      });
    backpackForm.style.display='block';
    fetch('http://localhost/lab/app/api/backpackController.php')
    .then((response) => {
        return response.json();
    })
    .then((data) => {
        //console.log(data);
        let content=``;
        for (i=0;i<data.length;i++){
            let propertyContent=``;
            for (const [key, value] of Object.entries(data[i].properties)) {
                propertyContent+=key+`: `+value+`</br>`;
            }
            content+=`<tr><td>`+data[i].id+`</td><td>`+data[i].name+`</td><td>`+data[i].vendor+`</td>
            <td>`+data[i].price+`</td><td>`+data[i].category+`</td><td>`+propertyContent+`</td></tr>`;
        }
        let table=document.getElementById('contentTable');
        table.innerHTML=`<thead>
                        <th>ID</th>
                        <th>Модель</th>
                        <th>Виробник</th>
                        <th>Ціна</th>
                        <th>Категорія</th>
                        <th>Характеристики</th>
                        </thead>
                        <tbody>
                            `+content+`
                        </tbody>`;
    });
}
getCategoryData();
getPropertyData();
getBackpackData();

categoryForm.addEventListener("submit", categorySubmit);
function categorySubmit(event){
    event.preventDefault();
    let inputName = document.getElementById('inputCategoryName').value;
    let formData = new FormData();
    formData.append('name', inputName);
    fetch("http://localhost/lab/app/api/categoryController.php",
        {
            body: formData,
            method: "POST"
        }).then(function(res){
            getCategoryData();
            categoryForm.reset();
        });
}


propertyForm.addEventListener("submit", propertySubmit);
function propertySubmit(event){
    event.preventDefault();
    let inputName = document.getElementById('inputPropertyName').value;
    let inputUnits = document.getElementById('inputPropertyUnits').value;
    let formData = new FormData();
    formData.append('name', inputName);
    formData.append('units', inputUnits);
    fetch("http://localhost/lab/app/api/propertyController.php",
        {
            body: formData,
            method: "POST"
        }).then(function(res){
            getPropertyData();
            propertyForm.reset();
        });
}

backpackForm.addEventListener("submit", backpackSubmit);
function backpackSubmit(event){
    event.preventDefault();
    let inputName = document.getElementById('inputBackpackName').value;
    let inputVendor = document.getElementById('inputBackpackVendor').value;
    let inputPrice = document.getElementById('inputBackpackPrice').value;
    let inputCategory = document.getElementById('inputBackpackCategory').value;
    let inputProperties = document.getElementById('inputBackpackProperties').value;
    let formData = new FormData();
    formData.append('name', inputName);
    formData.append('vendor', inputVendor);
    formData.append('price', inputPrice);
    formData.append('category', inputCategory);
    formData.append('properties', inputProperties);
    fetch("http://localhost/lab/app/api/backpackController.php",
        {
            body: formData,
            method: "POST"
        }).then(function(res){
            getBackpackData();
            backpackForm.reset();
        });
}
const categoryButton = document.getElementById("displayCategories");
categoryButton.addEventListener("click", getCategoryData);
const propertyButton = document.getElementById("displayProperties");
propertyButton.addEventListener("click", getPropertyData);
const backpackButton = document.getElementById("displayBackpacks");
backpackButton.addEventListener("click", getBackpackData);