#import libs
import csv
#dont forget to install matplotlib
import matplotlib.pyplot as plt
#dont forget to install numpy
import numpy as np
#function to import data from csv
def importData(filename, column):
    dataArray=[];
    with open(filename, 'r') as file:
        csvreader = csv.reader(file)
        i=0;
        for row in csvreader:
            if(i>3):          
            	dataArray.append(float(row[column-1].replace(',', '.')))
            i+=1
        return dataArray

def ecdf(a):
    x, counts = np.unique(a, return_counts=True)
    cusum = np.cumsum(counts)
    return x, cusum / cusum[-1]
def plot_ecdf(a):
    x, y = ecdf(a)
    x = np.insert(x, 0, x[0])
    y = np.insert(y, 0, 0.)
    plt.plot(x, y, drawstyle='steps-post')
    plt.grid(True)
    plt.show()    
def filter_zeros(array):
	resultArray=[]
	for i in range(0, len(array)):
		if (array[i]!=0):
			resultArray.append(array[i])
	return resultArray

def get_percentiles(array):
    print('25th percentile of data is: '+str(np.percentile(array, 25)))            
    print('50th percentile of data is: '+str(np.percentile(array, 50)))
    print('75th percentile of data is: '+ str(np.percentile(array, 75))) 		    	
#calling function			                                
#dataArray=filter_zeros(importData('./datapv.csv',9))
dataArray=importData('./datapv.csv',5)
print(str(len(dataArray)))
cdfData=ecdf(dataArray)
plot_ecdf(cdfData)
dataArray=filter_zeros(importData('./datapv.csv',16))
print(str(len(dataArray)))
cdfData=ecdf(dataArray)
plot_ecdf(cdfData)
#dataArray=filter_zeros(importData('./datapv.csv',16))
#get_percentiles(dataArray)