#import libs
import csv
#dont forget to install matplotlib
import matplotlib.pyplot as plt
#dont forget to install numpy
import numpy as np
#function to import data from csv
def importData(filename, column):
    dataArray=[]
    with open(filename, 'r') as file:
        csvreader = csv.reader(file)
        i=0
        for row in csvreader:
            if(i>3):          
            	dataArray.append(float(row[column-1].replace(',', '.')))
            i+=1
        return dataArray

def ecdf(a):
    x, counts = np.unique(a, return_counts=True)
    cusum = np.cumsum(counts)
    return x, cusum / cusum[-1]  
def plot_ecdf(a,b):
    x1, y1 = ecdf(a)
    x1 = np.insert(x1, 0, x1[0])
    y1 = np.insert(y1, 0, 0.)
    x2, y2 = ecdf(b)
    x2 = np.insert(x2, 0, x2[0])
    y2 = np.insert(y2, 0, 0.)
    plt.plot(x1, y1, drawstyle='steps-post')
    plt.plot(x2, y2, drawstyle='steps-post')
    plt.grid(True)
    plt.show()

def filter_zeros(array):
	resultArray=[]
	for i in range(0, len(array)):
		if (array[i]!=0):
			resultArray.append(array[i])
	return resultArray		    	
#calling function			                                
#dataArray1=importData('./datapv.csv',16)
dataArray1=filter_zeros(importData('./datapv.csv',16))
mu, sigma = np.mean(dataArray1), np.std(dataArray1) # mean and standard deviation
dataArray2 = np.random.normal(mu, sigma, len(dataArray1))
cdfData1=ecdf(dataArray1)
cdfData2=ecdf(dataArray2)
plot_ecdf(cdfData1,cdfData2)
#dataArray=filter_zeros(importData('./datapv.csv',16))
#get_percentiles(dataArray)