<?php

ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); 
session_start();
    if(!isset($_SESSION['username'])){
        header('Location: login.php');
    }
    require_once('../app/db_connect.php');
    require_once('../app/models/BackpackList.php');
    require_once('../app/models/CategoryList.php');
    require_once('../app/models/PropertyList.php');
    $bl=new BackpackList($conn);
	$backpack=$bl->getFromDatabaseById($_GET['id']);
    $pl=new PropertyList($conn);
	$pl->getAllFromDatabase();
    $cl=new CategoryList($conn);
	$cl->getAllFromDatabase();
    $backpackProps=$bl->getBackpackPropertiesById($_GET['id']);
    //print_r($backpackProps);
    if(isset($_POST['name'])){
        $bl->updateDatabaseById($_POST['id'],$_POST['name'],$_POST['vendor'],$_POST['price'],$_POST['category']);
        $propsArray=$pl->getDataAsArray();
        for ($i=0;$i<count($propsArray);$i++){
            $bl->refreshBackpackProperty($_POST['id'],$propsArray[$i]['id'],$_POST['prop_'.$propsArray[$i]['id']]);
        }
        header('Location:backpacks.php');
    }
?>
<html>
    <head>
        <title>Backpacks List</title>
        <link href="../assets/style.css" rel="stylesheet" />
    </head>
    <body>
        <div class='container'>
            <div class='navigation'>
                <ul>
                    <li><a href="backpacks.php">Рюкзаки</a></li>
                    <li><a href="categories.php">Категорії</a></li>
                    <li><a href="properties.php">Властивості</a></li>
                    <li><a href="logout.php">Вийти</a></li>
                </ul>
            </div>
            
            <div class='form-content'>
                <form method="POST">
                    <p><input value="<?php echo $backpack['name'];?>" type="text" placeholder="Модель" name="name" required/></p>
                    <p><input value="<?php echo $backpack['vendor'];?>" type="text" placeholder="Виробник" name="vendor" required/></p>
                    <p><?php echo $cl->getDataAsSelectWithSelectedOption($backpack['category_id']); ?></p>
                    <p><input value="<?php echo $backpack['price'];?>" type="number" placeholder="Ціна" name="price" required/></p>
                    <?php echo $pl->getDataAsInputBlockWithValues($backpackProps); ?>
                    <p><input value="<?php echo $backpack['id'];?>" type="hidden" name="id" required/></p>
                    <p><button type="submit">Зберегти</button></p>
                </form>
            </div>
            <div></div>
        </div>
    </body>
</html>