#import libs
import csv
#dont forget to install matplotlib
import matplotlib.pyplot as plt
#function to import data from csv
def importData(filename):
    dataArray=[];
    with open(filename, 'r') as file:
        csvreader = csv.reader(file)
        i=0;
        for row in csvreader:
            if(i>3):          
            	dataArray.append(float(row[2].replace(',', '.')))
            i+=1
        return dataArray
#get maximum value        
def findMaxValue(array):
    return max(array)
#get minimum value    
def findAvgValue(array):
    return sum(array)/len(array)
#get element index when sensor starts to receive solar radiation 
def findRadStartArrayElement(array):
    for i in range (0, len(array)):
    	if array[i]>0:
    	    return i
    return sum(array)/len(array)
#get element index when sensor stops to receive solar radiation     
def findRadEndArrayElement(array):
    for i in range (findRadStartArrayElement(array), len(array)):
    	if array[i]==0:
    	    return i-1
    return sum(array)/len(array)
#function to convert array index to time    
def convertIndexToTime(index):
	timeInMins=index*5
	hours=int(timeInMins/60)
	minutes=timeInMins%60
	return (str(hours)+":"+str(minutes))
#get solar day duration	
def getSolarDayDurationInHours(array):
	return convertIndexToTime(findRadEndArrayElement(array)-findRadStartArrayElement(array))
def getSolarDayDurationInPercentage(array):
	return str(100*(findRadEndArrayElement(array)-findRadStartArrayElement(array))/len(array))+'%'
#function to plot graph
def plotData(array):
    plt.plot(range(0,len(dataArray)), dataArray)
    plt.title('Data Graph')
    plt.show()	
#calling function			                                
dataArray=importData('./datapv.csv')
print('Max value: '+str(findMaxValue(dataArray)))            
print('Average value: '+str(findAvgValue(dataArray)))
print('Start time: '+ convertIndexToTime(findRadStartArrayElement(dataArray)))
print('End time: '+ convertIndexToTime(findRadEndArrayElement(dataArray)))
print('Solar day duration time: '+ getSolarDayDurationInHours(dataArray))
print('Solar day duration in percentage: '+ getSolarDayDurationInPercentage(dataArray))
print('Average value during solar day duration: '+str( findAvgValue(dataArray[findRadStartArrayElement(dataArray):findRadEndArrayElement(dataArray)])))
plotData(dataArray)               
