#import libs
import csv
#dont forget to install matplotlib
import matplotlib.pyplot as plt
#dont forget to install numpy
import numpy as np
import scipy
import math
from scipy.stats import shapiro

def importData(filename, column):
    dataArray=[]
    with open(filename, 'r') as file:
        csvreader = csv.reader(file)
        i=0
        for row in csvreader:
            if(i>3):          
            	dataArray.append(float(row[column-1].replace(',', '.')))
            i+=1
        return dataArray
def filter_zeros(array):
	resultArray=[]
	for i in range(0, len(array)):
		if (array[i]!=0):
			resultArray.append(array[i])
	return resultArray		    	
dataArray=filter_zeros(importData('./datapv.csv',9))
stat, p = shapiro(dataArray)
print('Statistics=%.3f, p=%.3f' % (stat, p))
# interpret results
alpha = 0.05
if p > alpha:
    print('Sample looks Gaussian (fail to reject H0)')
else:
    print('Sample does not look Gaussian (reject H0)')
res=scipy.stats.anderson(dataArray)
print (res.statistic)
print (res.critical_values)
print (res.significance_level)