<?php
	ini_set('display_errors', 1); 
	ini_set('display_startup_errors', 1); 
	error_reporting(E_ALL);
	abstract class BaseList{
		protected $dataArray;
		protected $index;
		public function __construct(){
			$this->dataArray=[];
			$this->index=0;
		}
		public function convertToJSON(){
			header("Content-Type: application/json");
			header('Content-type: text/plain; charset=utf-8');
			$jsonArray=[];
			for ($i=0; $i<count($this->dataArray);$i++){
				array_push($jsonArray,$this->dataArray[$i]->getAsJSONObject());
			}
			return json_encode($jsonArray,JSON_UNESCAPED_UNICODE);
		}
		abstract function readFromFile($path);
		abstract function convertToXML();
		public function delete($id){
			for ($i=0;$i<count($this->dataArray);$i++){
				if ($this->dataArray[$i]->getId()==$id){
					array_splice($this->dataArray, $i, 1); 
				}
			}
		}
		public function exportToFile($path){
			if (($handle = fopen($path, "w")) !== FALSE) {
				for ($i=0;$i<count($this->dataArray);$i++){
					fwrite($handle,$this->dataArray[$i]->getAsCSV());
				}
				fclose($handle);
			}
		}
		public function displayAll(){
			for ($i=0;$i<count($this->dataArray);$i++){
				echo $this->dataArray[$i]->displayInfo();
			}
		}
	}
	class BackpackList extends BaseList{
		public function add($name, $vendor, $category, $price, $properties){
			$id=++$this->index;
			$nb = new Backpack($id, $name,$vendor, $category, $price, $properties);
			array_push($this->dataArray,$nb);
			return $id;
		}
		public function readFromFile($path){
			$row = 1;
			if (($handle = fopen($path, "r")) !== FALSE) {
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
					eval('$propsArray='.$data[4].';');
					$this->add($data[0],$data[1],$data[2],$data[3],$propsArray);
				}
				fclose($handle);
			}
		}
		public function convertToXML(){
			header("Content-Type: text/xml");
			$XMLString='';
			for ($i=0;$i<count($this->dataArray);$i++){
				$XMLString.=$this->dataArray[$i]->getAsXML();
			}
			return '<?xml version="1.0" encoding="UTF-8"?><backpacks>'.$XMLString
			.'</backpacks>';
		}
		public function edit($id, $name, $vendor, $category, $price, $properties){
			for ($i=0;$i<count($this->dataArray);$i++){
				if ($this->dataArray[$i]->getId()==$id){
					$this->dataArray[$i]->edit($name, $vendor, $category, $price, $properties);
				}
			}
		}
		
	}
	class Backpack{
		private $id;
		private $name;
		private $vendor;
		private $category;
		private $price;
		private $properties;
		public function __construct($id, $name, $vendor, $category, $price, $properties){
			$this->id=$id;
			$this->name=$name;	
			$this->vendor=$vendor;
			$this->category=$category;
			$this->price=$price;
			$this->properties=$properties;	
		}
		public function getId(){
			return $this->id;
		}
		public function getAsCSV(){
			return '"'.$this->name.'","'.$this->vendor.'","'.$this->category.'","'.$this->price.'","'.$this->getPropertiesForCSV().'"'."\n";
		}
		public function getAsJSONObject(){
			return get_object_vars($this);
		}
		public function getAsXML(){
			return '<backpack>
					<id>'.$this->id.'</id>
					<name>'.$this->name.'</name>
					<vendor>'.$this->vendor.'</vendor>
					<category>'.$this->category.'</category>
					<price>'.$this->price.'</price>
					<properties>'.$this->getPropertiesForXML().'</properties>
					</backpack>';
		}
		private function getPropertiesForCSV(){
			$result="[";
			foreach($this->properties as $key => $value) {
				$result.=  "'".addslashes($key) . "' => '" . addslashes($value)."'";
				$result.=",";
			}
			$result=substr_replace($result ,"", -1);
			$result.="]";
			return $result;
		}
		private function getPropertiesForXML(){
			$result='';
			foreach($this->properties as $key => $value) {
				$result.='<property><key>'.$key.'</key><value>'.$value.'</value></property>';
			}
			return $result;
		}
		public function edit($name, $vendor, $category,$price, $properties){
			$this->name=$name;	
			$this->vendor=$vendor;
			$this->category=$category;
			$this->price=$price;
			$this->properties=$properties;
		}
		private function displayProperties(){
			$result='<i>Характеристики:</i></br>';
			foreach($this->properties as $key => $value) {
				$result.=  $key . ": " . $value;
			  	$result.=  "<br>";
			}
			return $result;
		}
		public function displayInfo(){
			return $this->id.". <b>".$this->vendor." ".$this->name."</b></br>
			Ціна: ".$this->price."<br>
			Категорія: ".$this->category."<br>". $this->displayProperties();
		}
		public function __destruct(){
			echo "";	
		}
	}
	
	
	class CategoryList extends BaseList{
		public function add($name){
			$id=++$this->index;
			$nc = new Category($id, $name);
			array_push($this->dataArray,$nc);
			return $id;
		}
		public function readFromFile($path){
			$row = 1;
			if (($handle = fopen($path, "r")) !== FALSE) {
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
					$this->add($data[0]);
				}
				fclose($handle);
			}
		}
		public function convertToXML(){
			header("Content-Type: text/xml");
			$XMLString='';
			for ($i=0;$i<count($this->dataArray);$i++){
				$XMLString.=$this->dataArray[$i]->getAsXML();
			}
			return '<?xml version="1.0" encoding="UTF-8"?><categories>'.$XMLString
			.'</categories>';
		}
		public function edit($id, $name){
			for ($i=0;$i<count($this->dataArray);$i++){
				if ($this->dataArray[$i]->getId()==$id){
					$this->dataArray[$i]->edit($name);
				}
			}
		}
		
	}
	class Category{
		private $id;
		private $name;
		public function __construct($id, $name){
			$this->id=$id;
			$this->name=$name;		
		}
		public function getAsJSONObject(){
			return get_object_vars($this);
		}
		public function displayInfo(){
			return $this->id.". ".$this->name."</br>";
		}
		public function getId(){
			return $this->id;
		}
		public function getAsXML(){
			return '<category>
					<id>'.$this->id.'</id>
					<name>'.$this->name.'</name>
					</category>';
		}
		
		public function edit($name){
			$this->name=$name;
		}
		public function getAsCSV(){
			return '"'.$this->name.'"'."\n";
		}
		public function __destruct(){
			echo "";	
		}
	}
	
	class PropertyList extends BaseList{
		public function add($name, $units){
			$id=++$this->index;
			$np = new Property($id, $name, $units);
			array_push($this->dataArray,$np);
			return $id;
		}
		public function readFromFile($path){
			$row = 1;
			if (($handle = fopen($path, "r")) !== FALSE) {
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
					$this->add($data[0],$data[1]);
				}
				fclose($handle);
			}
		}
		public function convertToXML(){
			header("Content-Type: text/xml");
			$XMLString='';
			for ($i=0;$i<count($this->dataArray);$i++){
				$XMLString.=$this->dataArray[$i]->getAsXML();
			}
			return '<?xml version="1.0" encoding="UTF-8"?><properties>'.$XMLString
			.'</properties>';
		}
		public function edit($id, $name, $units){
			for ($i=0;$i<count($this->dataArray);$i++){
				if ($this->dataArray[$i]->getId()==$id){
					$this->dataArray[$i]->edit($name, $units);
				}
			}
		}
		
	}
	
	class Property{
		private $id;
		private $name;
		private $units;
		public function __construct($id, $name,$units){
			$this->id=$id;
			$this->name=$name;
			$this->units=$units;		
		}
		public function getId(){
			return $this->id;
		}
		public function getAsJSONObject(){
			return get_object_vars($this);
		}
		public function edit($name,$units){
			$this->name=$name;
			$this->units=$units;
		}
		public function getAsCSV(){
			return '"'.$this->name.'","'.$this->units.'"'."\n";
		}
		public function getAsXML(){
			return '<property>
					<id>'.$this->id.'</id>
					<name>'.$this->name.'</name>
					<units>'.$this->units.'</units>
					</property>';
		}
		public function displayInfo(){
			return $this->id.". ".$this->name." <i>(".$this->units.")</i></br>";
		}
		public function __destruct(){
			echo "";	
		}
	}
	$bl= new BackpackList();
	$bl->readFromFile('backpacks.csv');
	echo $bl->convertToJSON();
	/*
	$bl->add('Flare', 'Osprey','Міські рюкзаки', '999',['Вага'=>'1.1','Об\'єм'=>'20']);
	$bl->displayAll();
	$bl->exportToFile('backpacks.csv');*/
	/*$pl= new PropertyList();
	$pl->readFromFile('properties.csv');
	$pl->add('Вага','кг');
	$pl->displayAll();
	$pl->exportToFile('properties.csv');*/
	/*$cl= new CategoryList();
	$cl->readFromFile('categories.csv');
	$cl->add('Похідні рюкзаки');
	$cl->displayAll();
	$cl->exportToFile('categories.csv');
	$cl= new CategoryList();
	$cl->add('Міські рюкзаки');
	$cl->add('Похідні рюкзаки');
	$cl->displayAll();
	echo '</br>';
	$pl= new PropertyList();
	$pl->add('Вага','кг');
	$pl->add('Об\'єм','л');
	$pl->displayAll();
	echo '</br>';
	$bl= new BackpackList();
	$bl->add('Flare', 'Osprey','Міські рюкзаки', '999',['Вага'=>'1.1','Об\'єм'=>'20']);
	$bl->add('Kestrel', 'Osprey','Похідні рюкзаки', '1999',['Вага'=>'1.6','Об\'єм'=>'65']);
	$bl->displayAll();
	echo '</br>';
	$bl->edit(2,'Kestrel', 'Osprey','Похідні рюкзаки', '2999',['Вага'=>'1.6','Об\'єм'=>'65']);
	$bl->displayAll();*/
?>