<?php
require_once('BaseList.php');
	class BackpackList extends BaseList{
		public function add($name, $vendor, $category, $price, $properties){
			$id=++$this->index;
			$nb=new Backpack($id,$name, $vendor, $category, $price, $properties);
			array_push($this->dataArray,$nb);
			return $id;
		}
        public function getAllFromDatabase(){
            $sql = "SELECT `backpack`.*,`category`.name catname FROM `backpack` 
            INNER JOIN `category` ON `backpack`.category_id=`category`.id  WHERE 1";
            $result = $this->conn->query($sql);
            if ($result->num_rows > 0) {
            // output data of each row
                while($row = $result->fetch_assoc()) {
                    $nc=new Backpack($row['id'],$row['name'],$row['vendor'],$row['price'],$row['catname'],$this->getBackackPropertiesById($row['id']));
                    array_push($this->dataArray,$nc);
                }
            } else {
            echo "0 results";
            }
        }
        public function getBackackPropertiesById($id){
            $sql = "SELECT `backpack_property`.*, `property`.name, `property`.`units` 
            FROM backpack_property INNER JOIN `property` 
            ON `property`.`id`=`backpack_property`.`property_id` 
            WHERE `backpack_property`.`backpack_id`=1";
            $result = $this->conn->query($sql);
            $propsArray=[];
            if ($result->num_rows > 0) {
                // output data of each row
                    while($row = $result->fetch_assoc()) {
                        array_push($propsArray,$row);
                    }
                } else {
                echo "0 results";
                }
            return $propsArray;
        }
        /*public function insertIntoDatabase($name){
            $stmt = $this->conn->prepare("INSERT INTO `category` VALUES(DEFAULT,?);");
            $stmt->bind_param("s", $name);
            $stmt->execute();
            $last_id = $this->conn->insert_id;
            $nc=new Category($last_id,$name);
            array_push($this->dataArray,$nc);
        }*/
		public function getDataAsXML(){
			header("Content-type: text/xml");
			$result='<?xml version="1.0" encoding="UTF-8"?>
			<backpacks>';
			for ($i=0; $i<count($this->dataArray);$i++){
				$result.=$this->dataArray[$i]->getDataAsXML();
			}
			$result.='</backpacks>';
			return $result;
		}
		public function importFromFile($fileName){
			$row = 1;
			if (($handle = fopen($fileName, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				eval('$propsArray='.$data[4].';');
				$this->add($data[0],$data[1],$data[2],$data[3],$propsArray);
				$row++;	
			}
			fclose($handle);
			}
		}
        
		public function edit($id,$name, $vendor, $category, $price, $properties){
			for ($i=0; $i<count($this->dataArray);$i++){
				if ($this->dataArray[$i]->getId()==$id){
					$this->dataArray[$i]->edit($name, $vendor, $category, $price, $properties);
					break;
				}
			}
		}
	}
	class Backpack{
		private $id;
		private $name;
		private $vendor;
		private $category;
		private $price;
		private $properties;
		public function __construct($id, $name, $vendor, $category, $price, $properties){
			$this->id=$id;
			$this->name=$name;	
			$this->vendor=$vendor;
			$this->category=$category;
			$this->price=$price;
			$this->properties=$properties;	
		}
		public function getId(){
			return $this->id;
		}
		public function getDataAsCSVRow(){
			return '"'.addslashes($this->name).'","'.addslashes($this->vendor).'","'.addslashes($this->category).'","'.addslashes($this->price).'","'.$this->getPropertiesForCSV().'"'."\n";
		}
		public function getDataAsXML(){
			return "
				<backpack>
					<id>".$this->id."</id>
					<name>".$this->name."</name>
					<vendor>".$this->vendor."</vendor>
					<category>".$this->category."</category>
					<price>".$this->price."</price>
					<properties>".$this->getPropertiesAsXML()."</properties>
				</backpack>
			";
		}
		public function getDataAsTableRow(){
			return "
				<tr>
					<td>".$this->id."</td>
					<td>".$this->name."</td>
					<td>".$this->vendor."</td>
					<td>".$this->category."</td>
					<td>".$this->price."</td>
					<td>".$this->displayProperties()."</td>
				</tr>
			";
		}
		public function edit($name, $vendor, $category, $price, $properties){
			$this->name=$name;	
			$this->vendor=$vendor;
			$this->category=$category;
			$this->price=$price;
			$this->properties=$properties;	
		}
		public function getAsJSONObject(){
			return get_object_vars($this);
		}
		private function getPropertiesForCSV(){
			$result="[";
			foreach($this->properties as $key => $value) {
				$result.=  "'".addslashes($key) . "' => '" . addslashes($value)."'";
				$result.=",";
			}
			$result=substr_replace($result ,"", -1);
			$result.="]";
			return $result;
		}
		private function displayProperties(){
			$result='<i>Характеристики:</i></br>';
			foreach($this->properties as $property) {
				$result.=  $property['name'] . ": " . $property['value']." (". $property['units'].")";
			  	$result.=  "<br>";
			}
			return $result;
		}
		private function getPropertiesAsXML(){
			$result='';
			foreach($this->properties as $key => $value) {
			  	$result.="<property><key>".$key."</key><value>".$value."</value></property>";
			}
			return $result;
		}
		public function displayInfo(){
			return $this->id.". <b>".$this->vendor." ".$this->name."</b></br>
			Ціна: ".$this->price."<br>
			Категорія: ".$this->category."<br>". $this->displayProperties();
		}
		public function __destruct(){
			echo "";	
		}
	}
?>