<?php
require_once('BaseList.php');
	class CategoryList extends BaseList{
		public function importFromFile($fileName){
			$row = 1;
			if (($handle = fopen($fileName, "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
				$this->add($data[0]);
				$row++;	
			}
			fclose($handle);
			}
		}
        public function getAllFromDatabase(){
            $sql = "SELECT * FROM `category` WHERE 1";
            $result = $this->conn->query($sql);
            if ($result->num_rows > 0) {
            // output data of each row
                while($row = $result->fetch_assoc()) {
                    $nc=new Category($row['id'],$row['name']);
                    array_push($this->dataArray,$nc);
                }
            } else {
            echo "0 results";
            }
        }
        public function insertIntoDatabase($name){
            $stmt = $this->conn->prepare("INSERT INTO `category` VALUES(DEFAULT,?);");
            $stmt->bind_param("s", $name);
            $stmt->execute();
            $last_id = $this->conn->insert_id;
            $nc=new Category($last_id,$name);
            array_push($this->dataArray,$nc);
        }
		public function getDataAsXML(){
			header("Content-type: text/xml");
			$result='<?xml version="1.0" encoding="UTF-8"?>
			<categories>';
			for ($i=0; $i<count($this->dataArray);$i++){
				$result.=$this->dataArray[$i]->getDataAsXML();
			}
			$result.='</categories>';
			return $result;
		}
		public function getDataAsSelect(){
			$result='<select name="category">';
			for ($i=0; $i<count($this->dataArray);$i++){
				$result.=$this->dataArray[$i]->getDataAsOption();
			}
			$result.='</select>';
			return $result;
		}
		public function add($name){
			$id=++$this->index;
			$nc=new Category($id,$name);
			array_push($this->dataArray,$nc);
			return $id;
		}
		public function edit($id,$name){
			for ($i=0; $i<count($this->dataArray);$i++){
				if ($this->dataArray[$i]->getId()==$id){
					$this->dataArray[$i]->edit($name);
					break;
				}
			}
		}
	}
	class Category{
		private $id;
		private $name;
		public function __construct($id, $name){
			$this->id=$id;
			$this->name=$name;		
		}
		public function getId(){
			return $this->id;
		}
		public function edit($name){
			$this->name=$name;
		}
		public function getDataAsXML(){
			return "
				<category>
					<id>".$this->id."</id>
					<name>".$this->name."</name>
				</category>
			";
		}
		public function getDataAsOption(){
			return "<option value='".$this->id."'>".$this->name."</option>";
		}
		public function getDataAsTableRow(){
			return "
				<tr>
					<td>".$this->id."</td>
					<td>".$this->name."</td>
				</tr>
			";
		}
		public function displayInfo(){
			return $this->id.". ".$this->name."</br>";
		}
		public function getDataAsCSVRow(){
			return '"'.addslashes($this->name).'"'."\n";
		}
		public function __destruct(){
			echo "";	
		}
		public function getAsJSONObject(){
			return get_object_vars($this);
		}
	}