<?php
    session_start();
    if(!isset($_SESSION['username'])){
        echo '{"error":"Unauthorized"}';
        die();
    }
    require_once('../db_connect.php');
    require_once('../models/BackpackList.php');
    require_once('../models/PropertyList.php');
    $pl=new PropertyList($conn);
    $pl->getAllFromDatabase();
    $bl=new BackpackList($conn);
    if($_SERVER['REQUEST_METHOD']=="GET"&&!isset($_GET['id'])){
        
        if(!isset($_GET['search'])){
            $bl->getAllFromDatabase();
        } else{
            $bl->getAllFromDatabaseBySearchCriteria($_GET['search']);
        }
        echo $bl->convertToJSON();
    }
    
    if($_SERVER['REQUEST_METHOD']=="GET"&&isset($_GET['id'])){
        $record=$bl->getFromDatabaseById($_GET['id']);
        $record['properties']=$bl->getBackpackPropertiesById($_GET['id']);
        echo json_encode($record,JSON_UNESCAPED_UNICODE);
    }
    
    if($_SERVER['REQUEST_METHOD']=="POST"){
        $data = json_decode( file_get_contents('php://input') );
        $backpackId=$bl->insertIntoDatabase($data->name,$data->vendor,$data->price,$data->category);       
        $propsArray=$pl->getDataAsArray();
        //echo json_encode($propsArray);
        for($i=0;$i<count($propsArray);$i++){
            $bl->addBackpackProperty($backpackId,$propsArray[$i]['id'],$data->{'prop_'.$propsArray[$i]['id']});
        }
    }
    if($_SERVER['REQUEST_METHOD']=="DELETE"){
        $bl->deleteFromDatabase($_REQUEST['id']);
        echo '{"status":"success"}';
    }
    if($_SERVER['REQUEST_METHOD']=="PUT"){
        $data = json_decode( file_get_contents('php://input') );
        $bl->updateDatabaseById($data->id,$data->name,$data->vendor,$data->price,$data->category);
        $propsArray=$pl->getDataAsArray();
        for ($i=0;$i<count($propsArray);$i++){
            $bl->refreshBackpackProperty($data->id,$propsArray[$i]['id'],$data->{'prop_'.$propsArray[$i]['id']});
        }
        echo json_encode($propsArray);
        //echo '{"status":"success"}';
    }
    
?>