<?php
require_once('../app/BaseList.php');
require_once('../app/Category.php');
class CategoryList extends BaseList{
    public function add($params){
        $this->id++;
        $params['id']=$this->id;
        $newObj=new Category($params);
        array_push($this->dataArray,$newObj);
    }
    public function exportAsArray(){
        $result=array(['name']);
        foreach($this->dataArray as $item){
            array_push($result,$item->getAsArray());
        }
        return $result;
    }
    public function exportAsXML(){
        $result='<?xml version="1.0" encoding="UTF-8"?><categories>';
        foreach($this->dataArray as $item){
            $result.=$item->getAsXML();
        }
        $result.='</categories>';
        return $result;
    }
    public function readFromFile(){
        $row=0;
        if (($handle = fopen("../data/categories.csv", "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
              if($row>0){
                $dataArray=array('name'=>$data[0]);
                $this->add($dataArray);
              }
              $row++;
            }
            fclose($handle);
        }
    }
    public function saveToFile(){
        $fp = fopen('../data/categories.csv', 'w');
        foreach ($this->exportAsArray() as $row) {
            fputcsv($fp, $row);
        }
        fclose($fp);
    }
    
    
}