<?php
require_once('../app/BaseList.php');
require_once('../app/Backpack.php');
class BackpackList extends BaseList{
    public function add($params){
        $this->id++;
        $params['id']=$this->id;
        $newObj=new Backpack($params);
        array_push($this->dataArray,$newObj);
    }
    public function exportAsArray(){
        $result=array(['model','brand','price','category','parameters']);
        foreach($this->dataArray as $item){
            array_push($result,$item->getAsArray());
        }
        return $result;
    }
    public function exportAsXML(){
        $result='<?xml version="1.0" encoding="UTF-8"?><backpacks>';
        foreach($this->dataArray as $item){
            $result.=$item->getAsXML();
        }
        $result.='</backpacks>';
        return $result;
    }
    public function readFromFile(){
        $row=0;
        if (($handle = fopen("../data/backpacks.csv", "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
              if($row>0){
                $dataArray=array('brand'=>$data[0],'model'=>$data[1],'price'=>$data[2],'category'=>$data[3],'parameters'=>$data[4]);
                $this->add($dataArray);
              }
              $row++;
            }
            fclose($handle);
        }
    }
    public function saveToFile(){
        $fp = fopen('../data/backpacks.csv', 'w');
        foreach ($this->exportAsArray() as $row) {
            fputcsv($fp, $row);
        }
        fclose($fp);
    }
}