<?php
require_once('../app/BaseList.php');
require_once('../app/Parameter.php');
class ParameterList extends BaseList{
    public function add($params){
        $this->id++;
        $params['id']=$this->id;
        $newObj=new Parameter($params);
        array_push($this->dataArray,$newObj);
    }
    public function exportAsArray(){
        $result=array(['name','units']);
        foreach($this->dataArray as $item){
            array_push($result,$item->getAsArray());
        }
        return $result;
    }
    public function exportAsXML(){
        $result='<?xml version="1.0" encoding="UTF-8"?><parameters>';
        foreach($this->dataArray as $item){
            $result.=$item->getAsXML();
        }
        $result.='</parameters>';
        return $result;
    }
    public function readFromFile(){
        $row=0;
        if (($handle = fopen("../data/parameters.csv", "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
              if($row>0){
                $dataArray=array('name'=>$data[0],'units'=>$data[1]);
                $this->add($dataArray);
              }
              $row++;
            }
            fclose($handle);
        }
    }
    public function saveToFile(){
        $fp = fopen('../data/parameters.csv', 'w');
        foreach ($this->exportAsArray() as $row) {
            fputcsv($fp, $row);
        }
        fclose($fp);
    }
}