<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
session_start();
if(!isset($_SESSION['user'])){
    header('Location:login.php');
}
require_once('../app/CategoryList.php');
$catList=new CategoryList();    
$catList->readFromFile();
$idContent='';
$nameContent='';
if(isset($_GET['id'])){
    $data=$catList->getItemById($_GET['id']);
    $idContent=$data['id'];
    $nameContent=$data['name'];
}
if(isset($_POST['name'])){
    if($_POST['id']==""){
        $catList->add(array('name'=>$_POST['name']));
    } else{
        $catList->update(array('id'=>$_POST['id'],'name'=>$_POST['name']));
    }
    $catList->saveToFile();
    header('Location: ./category-list.php');
}
?>
<html>
    <head>
        <title>Content Management System</title>
        <meta charset="utf-8"/>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
        <link href="../assets/style.css" rel="stylesheet"/>
    </head>
    <body>
        <div class="container">
            <h2>Система керування контентом</h2>
            <h1>Додати категорію</h1>
            <nav class="navbar-nav d-flex flex-row">
                <li class="nav-item"><a class="nav-item" href="category-list.php">Список категорій</a></li>
                <li class="nav-item"><a class="nav-item" href="add-category.php">Додати категорію</a></li>
                <li class="nav-item"><a class="nav-item" href="parameter-list.php">Список параметрів</a></li>
                <li class="nav-item"><a class="nav-item" href="add-parameter.php">Додати параметр</a></li>
                <li class="nav-item"><a class="nav-item" href="backpack-list.php">Список рюкзаків</a></li>
                <li class="nav-item"><a class="nav-item" href="add-backpack.php">Додати рюкзак</a></li>
                <li class="nav-item"><a class="nav-item" href="logout.php">Вийти</a></li>
            </nav>
            <div class="mt-3">
                <form method="POST">
                    <p>
                        <input class="form-input" value="<?php echo $nameContent;?>" name="name" type="text" placeholder="Назва категорії" required/>
                    </p>
                    <input type="hidden" name="id" value="<?php echo $idContent;?>"/>
                    <p>
                        <button class="btn btn-success" type="submit">Додати</button>
                    </p>
                </form>
            </div>
        </div>
    </body>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</html>