<?php
class Parameter{
    private $id;
    private $name;
    private $units;
    public function __construct($params){
        $this->id=$params['id'];
        $this->name=$params['name'];
        $this->units=$params['units'];
    }
    public function displayInfo(){
        echo $this->id.'. '.$this->name.' ('.$this->units.')</br>';
    }
    public function update($params){
        
        if(isset($params['id'])){
            $this->id=$params['id'];
        }
        if(isset($params['name'])){
            $this->name=$params['name'];
        }
        if(isset($params['units'])){
            $this->units=$params['units'];
        }
    }
    public function __delete(){}
    public function getId(){
        return $this->id;
    }
    public function getAsArray(){
        return array($this->name,$this->units);
    }
    public function getAsAssocArray(){
        return array('id'=>$this->id,'name'=>$this->name,'units'=>$this->units);
    }
    public function getAsXML(){
        return '<parameter>
                    <id>'.$this->id.'</id>
                    <name>'.$this->name.'</name>
                    <units>'.$this->units.'</units>
                </parameter>';
    }
    public function getAsTableRow(){
        return '<tr>
                    <td>'.$this->id.'</td>
                    <td>'.$this->name.'</td>
                    <td>'.$this->units.'</td>
                    <td><a href="add-parameter.php?id='.$this->id.'">Редагувати</a><a href="parameter-list.php?action=delete&id='.$this->id.'">Видалити</a></td>
                </tr>';
    }
}