<?php
require_once('../models/BaseList.php');
require_once('../models/Backpack.php');
class BackpackList extends BaseList{
    public function add($params){
        if(isset($params['id'])){
            $this->id++;
        } else{
            $this->id++;
            $params['id']=$this->id;
        }
        $newObj=new Backpack($params);
        array_push($this->dataArray,$newObj);
    }
    public function exportAsArray(){
        $result=array(['model','brand','price','category','parameters']);
        foreach($this->dataArray as $item){
            array_push($result,$item->getAsArray());
        }
        return $result;
    }
    public function exportAsXML(){
        $result='<?xml version="1.0" encoding="UTF-8"?><backpacks>';
        foreach($this->dataArray as $item){
            $result.=$item->getAsXML();
        }
        $result.='</backpacks>';
        return $result;
    }
    public function readFromFile(){
        $row=0;
        if (($handle = fopen("../data/backpacks.csv", "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
              if($row>0){
                $dataArray=array('brand'=>$data[0],'model'=>$data[1],'price'=>$data[2],'category'=>$data[3],'parameters'=>$data[4]);
                $this->add($dataArray);
              }
              $row++;
            }
            fclose($handle);
        }
    }
    public function saveToFile(){
        $fp = fopen('../data/backpacks.csv', 'w');
        foreach ($this->exportAsArray() as $row) {
            fputcsv($fp, $row);
        }
        fclose($fp);
    }
    public function getAllFromDatabase($conn){
        $sql = "SELECT backpacks.*, categories.name category FROM backpacks INNER JOIN categories on backpacks.category_id=categories.id";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            $row['parameters']=json_encode($this->getParametersByBackpackId($conn,$row['id']),JSON_UNESCAPED_UNICODE);
            $this->add($row);
        }
        }
    }
    public function deleteFromDatabaseById($conn,$id){
        $stmt = $conn->prepare("DELETE from backpacks WHERE id=?");
        $stmt->bind_param("s", $id);
        $stmt->execute();
        return true;
    }
    public function addToDatabase($conn,$params){
        $stmt = $conn->prepare("INSERT INTO `backpacks` VALUES (DEFAULT,?,?,?,?)");
        $stmt->bind_param("ssss", $model, $brand,$price,$categoryid);
        $model=$params['model'];
        $brand=$params['brand'];
        $price=$params['price'];
        $categoryid=$params['categoryid'];
        $stmt->execute();
        return true;
    }
    public function addToBackpackParameterToDatabase($conn,$params){
        $stmt = $conn->prepare("INSERT INTO `backpack_parameters` VALUES (DEFAULT,?,?,?)");
        $stmt->bind_param("sss", $backpackid, $parameterid,$value);
        $backpackid=$params['backpackid'];
        $parameterid=$params['parameterid'];
        $value=$params['value'];
        $stmt->execute();
        return true;
    }
    public function updateBackpackParameterInDatabase($conn,$params){
        $stmt = $conn->prepare("UPDATE `backpack_parameters` SET value=? WHERE backpack_id=? AND parameter_id=?");
        $stmt->bind_param("sss",$value, $backpackid, $parameterid);
        $backpackid=$params['backpackid'];
        $parameterid=$params['parameterid'];
        $value=$params['value'];
        $stmt->execute();
        return true;
    }
    
    public function updateDatabaseRecord($conn,$params){
        $stmt = $conn->prepare("UPDATE `backpacks` SET `model`=?,`brand`=?,`price`=?,`category_id`=? WHERE id=?");
        $stmt->bind_param("sssss", $model,$brand,$price,$category_id,$id);
        $model=$params['model'];
        $brand=$params['brand'];
        $price=$params['price'];
        $category_id=$params['categoryid'];
        $id=$params['id'];
        $stmt->execute();
        return true;
    }
    
    public function getParametersByBackpackId($conn,$id){
        $sql = "SELECT backpack_parameters.*, parameters.name, parameters.units FROM backpack_parameters INNER JOIN parameters on parameters.id=backpack_parameters.parameter_id WHERE backpack_id=".$id;
        $result = $conn->query($sql);
        $paramArray=array();
        if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            $param = new stdClass();
            $param->parameter_id=$row['parameter_id'];
            $param->name=$row['name'];
            $param->units=$row['units'];
            $param->value=$row['value'];
            array_push($paramArray,$param);
        }
        
        }
        return $paramArray;
    }
}