<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
session_start();
if(!isset($_SESSION['user'])){
    header('Location:login.php');
}
require_once('../dbconnect.php');
require_once('../models/BackpackList.php');
require_once('../models/CategoryList.php');
require_once('../models/ParameterList.php');
$catList=new CategoryList();    
$catList->getAllFromDatabase($conn);
$bpList=new BackpackList();    
$bpList->getAllFromDatabase($conn);
$paramList=new ParameterList();    
$paramList->getAllFromDatabase($conn);
$backpackParams=array();
$idContent='';
$modelContent='';
$brandContent='';
$priceContent='';
$categoryContent='';
$parametersContent='';
if(isset($_GET['id'])){
    $data=$bpList->getItemById($_GET['id']);
    $idContent=$data['id'];
    $modelContent=$data['model'];
    $brandContent=$data['brand'];
    $priceContent=$data['price'];
    $categoryContent=$data['category'];
    $parametersContent=$data['parameters'];
    $backpackParams=$bpList->getParametersByBackpackId($conn,$_GET['id']);
}
if(isset($_POST['model'])){
    if($_POST['id']==""){
        $bpList->addToDatabase($conn,array(
        'brand'=>$_POST['brand'],
        'model'=>$_POST['model'],
        'price'=>$_POST['price'],
        'categoryid'=>$_POST['categoryid']));
        $newBpId=$conn->insert_id;
        foreach($paramList->exportAsAssocArrays() as $item){
            $bpList->addToBackpackParameterToDatabase($conn,array(
                "backpackid"=>$newBpId,
                "parameterid"=>$item['id'],
                "value"=>$_POST['param'.$item['id']],
            ));
        }
    
    } else{
        $bpList->updateDatabaseRecord(array(
        'id'=>$_POST['id'],
        'brand'=>$_POST['brand'],
        'model'=>$_POST['model'],
        'price'=>$_POST['price'],
        'category'=>$_POST['category'],
        'parameters'=>$_POST['parameters']));
        foreach($paramList->exportAsAssocArrays() as $item){
            $bpList->updateBackpackParameterInDatabase($conn,array(
                "backpackid"=>$_POST['id'],
                "parameterid"=>$item['id'],
                "value"=>$_POST['param'.$item['id']],
            ));
        }
    }
    header('Location: ./backpack-list.php');
}
?>
<html>
    <head>
        <title>Content Management System</title>
        <meta charset="utf-8"/>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
        <link href="../assets/style.css" rel="stylesheet"/>
    </head>
    <body>
        <div class="container">
            <h2>Система керування контентом</h2>
            <h1>Додати категорію</h1>
            <nav class="navbar-nav d-flex flex-row">
                <li class="nav-item"><a class="nav-item" href="category-list.php">Список категорій</a></li>
                <li class="nav-item"><a class="nav-item" href="add-category.php">Додати категорію</a></li>
                <li class="nav-item"><a class="nav-item" href="parameter-list.php">Список параметрів</a></li>
                <li class="nav-item"><a class="nav-item" href="add-parameter.php">Додати параметр</a></li>
                <li class="nav-item"><a class="nav-item" href="backpack-list.php">Список рюкзаків</a></li>
                <li class="nav-item"><a class="nav-item" href="add-backpack.php">Додати рюкзак</a></li>
                <li class="nav-item"><a class="nav-item" href="logout.php">Вийти</a></li>
            </nav>
            <div class="mt-3">
                <form method="POST">
                    <p>
                        <input class="form-input" name="model" value="<?php echo $modelContent;?>" type="text" placeholder="Модель" required/>
                    </p>
                    <p>
                        <input class="form-input" name="brand" value="<?php echo $brandContent;?>" type="text" placeholder="Бренд" required/>
                    </p>
                    <p>
                        <input class="form-input" name="price" value="<?php echo $priceContent;?>" type="text" placeholder="Ціна" required/>
                    </p>
                    <p>
                        Виберіть категорію: <select name="categoryid" required>
                            <?php echo $catList->exportAsDropdownItems();?>
                        </select>
                    </p>
                    <p>
                        <?php echo $paramList->exportAsInputs($backpackParams);?>                    
                    </p>
                    <input type="hidden" name="id" value="<?php echo $idContent;?>"/>
                    <p>
                        <button class="btn btn-success" type="submit">Додати</button>
                    </p>
                </form>
            </div>
        </div>
    </body>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</html>