<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
require_once('../app/dbconnect.php');
require_once('../app/BackpackList.php');
require_once('../app/ParameterList.php');
header('Content-Type: application/json; charset=utf-8');
session_start();
if(!isset($_SESSION['user'])){
  echo json_encode(array("login"=>false));
  die();
}
$backpackList=new BackpackList();
$backpackList->getAllFromDatabase($conn);
$paramList=new ParameterList();    
$paramList->getAllFromDatabase($conn);    
if($_SERVER['REQUEST_METHOD']=="POST"){
  $backpackData=json_decode(file_get_contents('php://input'), TRUE);
  $backpackList->addToDatabase($conn,$backpackData);
  $newBpId=$conn->insert_id;
  foreach($paramList->exportAsAssocArrays() as $item){
    $backpackList->addToBackpackParameterToDatabase($conn,array(
        "backpackid"=>$newBpId,
        "parameterid"=>$item['id'],
        "value"=>$backpackData['param'.$item['id']],
    ));
} 
} else if($_SERVER['REQUEST_METHOD']=="PUT"){
  $backpackData=json_decode(file_get_contents('php://input'), TRUE);
  $backpackList->updateDatabaseRecord($conn,$backpackData);
  foreach($paramList->exportAsAssocArrays() as $item){
    $backpackList->updateBackpackParameterInDatabase($conn,array(
        "backpackid"=>$backpackData['id'],
        "parameterid"=>$item['id'],
        "value"=>$backpackData['param'.$item['id']],
    ));
  }
} else if($_SERVER['REQUEST_METHOD']=="DELETE"){
  $backpackData=json_decode(file_get_contents('php://input'), TRUE);
  $backpackList->deleteFromDatabaseById($conn,$backpackData['id']);
}
echo $backpackList->exportAsJSON();