<?php
class Backpack{
    private $id;
    private $brand;
    private $model;
    private $price;
    private $category;
    private $parameters;
    public function __construct($params){
        $this->id=$params['id'];
        $this->brand=$params['brand'];
        $this->model=$params['model'];
        $this->price=$params['price'];
        $this->category=$params['category'];
        $this->parameters=$params['parameters'];
    }
    public function displayInfo(){
        echo $this->id.'. '.$this->brand.' '.$this->model.'</br>
        Ціна: '.$this->price.'</br>
        Категорія: '.$this->category.'</br>
        <i>Характеристики</i></br>';
        $paramData=json_decode($this->parameters,true);
        foreach ($paramData as $item){
            echo $item['name'].': '.$item['value'].'</br>';
        }
    }
    public function update($params){
        if(isset($params['id'])){
            $this->id=$params['id'];
        }
        if(isset($params['brand'])){
            $this->brand=$params['brand'];
        }
        if(isset($params['model'])){
            $this->model=$params['model'];
        }
        if(isset($params['price'])){
            $this->price=$params['price'];
        }
        if(isset($params['category'])){
            $this->category=$params['category'];
        }
        if(isset($params['parameters'])){
            $this->parameters=$params['parameters'];
        }
    }
    public function __delete(){}
    public function getId(){
        return $this->id;
    }
    public function getAsArray(){
        return array($this->model,$this->brand,$this->price,$this->category,$this->parameters);
    }
    public function getAsAssocArray(){
        return array('id'=>$this->id,'model'=>$this->model,'brand'=>$this->brand,'price'=>$this->price,'category'=>$this->category,'parameters'=>$this->parameters);
    }
    public function getAsXML(){
        $paramData=json_decode($this->parameters,true);
        $paramString='';
        foreach($paramData as $item){
            $paramString.='<parameter><name>'.$item["name"].'</name><value>'.$item["value"].'</value></parameter>';
        }
        return '<parameter>
                    <id>'.$this->id.'</id>
                    <model>'.$this->model.'</model>
                    <brand>'.$this->brand.'</brand>
                    <price>'.$this->price.'</price>
                    <category>'.$this->category.'</category>
                    <parameters>'. $paramString.'</parameters>
                </parameter>';
    }
    public function getAsTableRow(){
        $paramData=json_decode($this->parameters,true);
        $paramString='';
        foreach($paramData as $item){
            $paramString.=$item['name'].": ".$item['value']." ".$item['units'].'</br>';
        }
        return '<tr>
                    <td>'.$this->id.'</td>
                    <td>'.$this->brand.'</td>
                    <td>'.$this->model.'</td>
                    <td>'.$this->price.'</td>
                    <td>'.$this->category.'</td>
                    <td>'.$paramString.'</td>
                    <td><a href="add-backpack.php?id='.$this->id.'">Редагувати</a><a href="backpack-list.php?action=delete&id='.$this->id.'">Видалити</a></td>
                </tr>';
    }
}